/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.tomitribe.churchkey.Decoder;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.pem.BeginDsaPrivateKey;
import org.tomitribe.churchkey.pem.BeginPrivateKey;
import org.tomitribe.churchkey.pem.BeginPublicKey;
import org.tomitribe.churchkey.pem.BeginRsaPrivateKey;
import org.tomitribe.churchkey.pem.BeginRsaPublicKey;
import org.tomitribe.churchkey.util.Pem;
import org.tomitribe.churchkey.util.Utils;

public class PemParser
implements Key.Format.Parser {
    private final PemDecoder decoder = new PemDecoder();

    @Override
    public Key decode(byte[] bytes) {
        return this.decoder.decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        switch (key.getType()) {
            case PUBLIC: {
                return BeginPublicKey.encode(key);
            }
            case PRIVATE: {
                return BeginPrivateKey.encode(key);
            }
            case SECRET: {
                throw new UnsupportedOperationException("Secret keys cannot be exported to PEM format.");
            }
        }
        throw new UnsupportedOperationException("Unsupported key type: " + (Object)((Object)key.getType()));
    }

    public static class PemDecoder
    implements Decoder {
        private final Map<String, Function<byte[], Key>> converters = new HashMap<String, Function<byte[], Key>>();

        public PemDecoder() {
            this.converters.put("PRIVATE KEY", BeginPrivateKey::decode);
            this.converters.put("PUBLIC KEY", BeginPublicKey::decode);
            this.converters.put("RSA PRIVATE KEY", BeginRsaPrivateKey::decode);
            this.converters.put("RSA PUBLIC KEY", BeginRsaPublicKey::decode);
            this.converters.put("DSA PRIVATE KEY", BeginDsaPrivateKey::decode);
        }

        @Override
        public Key decode(byte[] key) {
            if (!Utils.startsWith("-----", key)) {
                return null;
            }
            Pem pem = Pem.parse(key);
            Function<byte[], Key> converter = this.converters.get(pem.getType());
            if (converter == null) {
                throw new UnsupportedOperationException(String.format("Unsupported PEM format '%s'", pem.getType()));
            }
            return converter.apply(pem.getData());
        }
    }
}

