/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ssh;

import java.util.Base64;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.ssh.OpenSSHPrivateKey;
import org.tomitribe.churchkey.ssh.OpenSSHPublicKey;
import org.tomitribe.churchkey.util.Utils;

public class OpenSSHParser
implements Key.Format.Parser {
    @Override
    public byte[] encode(Key key) {
        switch (key.getType()) {
            case PUBLIC: {
                return new OpenSSHPublicKey().encode(key);
            }
            case PRIVATE: {
                throw new UnsupportedOperationException("Unsupported key type: " + (Object)((Object)key.getType()));
            }
            case SECRET: {
                throw new UnsupportedOperationException("Secret keys cannot be exported to PEM format.");
            }
        }
        throw new UnsupportedOperationException("Unsupported key type: " + (Object)((Object)key.getType()));
    }

    @Override
    public Key decode(byte[] bytes) {
        if (Utils.startsWith("ssh-", bytes) || Utils.startsWith("ecdsa-", bytes)) {
            return new OpenSSHPublicKey().decode(bytes);
        }
        if (Utils.startsWith("-----BEGIN OPENSSH PRIVATE KEY-----", bytes)) {
            return OpenSSHPrivateKey.decode(bytes);
        }
        return null;
    }

    public static String base64(byte[] src) {
        return Base64.getEncoder().encodeToString(src);
    }
}

