/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ssh;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.HashMap;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.ec.Curve;
import org.tomitribe.churchkey.ec.Ecdsa;
import org.tomitribe.churchkey.ssh.KeyInput;
import org.tomitribe.churchkey.util.Pem;
import org.tomitribe.util.Hex;

public class OpenSSHPrivateKey {
    private OpenSSHPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        Pem pem = Pem.parse(bytes);
        try {
            KeyInput keyInput = new KeyInput(pem.getData());
            OpenSSHPrivateKey.assertString("Auth Magic", "openssh-key-v1", keyInput.readAuthMagic());
            OpenSSHPrivateKey.assertString("ciphername", "none", keyInput.readString());
            OpenSSHPrivateKey.assertString("kdfname", "none", keyInput.readString());
            OpenSSHPrivateKey.assertString("kdf", "", keyInput.readString());
            OpenSSHPrivateKey.assertInt("number of keys", 1, keyInput.readInt());
            byte[] sshpublic = keyInput.readBytes();
            keyInput.readInt();
            keyInput.readInt();
            keyInput.readInt();
            String keyType = keyInput.readString();
            if ("ssh-rsa".equals(keyType)) {
                return OpenSSHPrivateKey.readRsaPrivateKey(keyInput);
            }
            if ("ssh-dss".equals(keyType)) {
                return OpenSSHPrivateKey.readPrivateDssKey(keyInput);
            }
            if ("ecdsa-sha2-nistp256".equals(keyType)) {
                return OpenSSHPrivateKey.readEcdsaPrivateKey(Curve.nistp256, keyInput);
            }
            if ("ecdsa-sha2-nistp384".equals(keyType)) {
                return OpenSSHPrivateKey.readEcdsaPrivateKey(Curve.nistp384, keyInput);
            }
            if ("ecdsa-sha2-nistp521".equals(keyType)) {
                return OpenSSHPrivateKey.readEcdsaPrivateKey(Curve.nistp521, keyInput);
            }
            throw new UnsupportedOperationException("Unsupported key type: " + keyType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static Key readPrivateDssKey(KeyInput keyInput) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger p = keyInput.readBigInteger();
        BigInteger q = keyInput.readBigInteger();
        BigInteger g = keyInput.readBigInteger();
        BigInteger unknown = keyInput.readBigInteger();
        BigInteger x = keyInput.readBigInteger();
        DSAPrivateKeySpec spec = new DSAPrivateKeySpec(x, p, q, g);
        KeyFactory result = KeyFactory.getInstance("DSA");
        PrivateKey publicKey = result.generatePrivate(spec);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("comment", keyInput.readString());
        return new Key(publicKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.OPENSSH, attributes);
    }

    private static Key readRsaPrivateKey(KeyInput keyInput) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger modulus = keyInput.readBigInteger();
        BigInteger publicExp = keyInput.readBigInteger();
        BigInteger privateExp = keyInput.readBigInteger();
        BigInteger crtCoef = keyInput.readBigInteger();
        BigInteger primeP = keyInput.readBigInteger();
        BigInteger primeQ = keyInput.readBigInteger();
        String comment = keyInput.readString();
        BigInteger one = BigInteger.valueOf(1L);
        BigInteger primeExpP = privateExp.mod(primeP.subtract(one));
        BigInteger primeExpQ = privateExp.mod(primeQ.subtract(one));
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, primeP, primeQ, primeExpP, primeExpQ, crtCoef);
        KeyFactory result = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = result.generatePrivate(spec);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("comment", comment);
        return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.OPENSSH, attributes);
    }

    private static Key readEcdsaPrivateKey(Curve curve, KeyInput keyInput) throws IOException {
        String curveName = keyInput.readString();
        if (!curve.name().equals(curveName)) {
            throw new IllegalStateException(String.format("Mismatched curve %s does not match key type of ecdsa-sha2-%s", curveName, curve.name()));
        }
        byte[] q = keyInput.readBytes();
        ECPoint ecPoint = OpenSSHPrivateKey.getEcPoint(q);
        BigInteger d = keyInput.readBigInteger();
        ECPrivateKey ecPrivateKey = Ecdsa.Private.builder().curveName(curveName).d(d).x(ecPoint.getAffineX()).y(ecPoint.getAffineY()).build().toKey();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String comment = keyInput.readString();
        if (comment != null) {
            attributes.put("Comment", comment);
        } else {
            attributes.put("Comment", "");
        }
        return new Key(ecPrivateKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.OPENSSH, attributes);
    }

    public static ECPoint getEcPoint(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalStateException("Key data is truncated");
        }
        if (bytes[0] != 4) {
            byte[] format = new byte[]{bytes[0]};
            throw new UnsupportedOperationException("Only uncompressed EC points are supported.  Found EC point compression format of " + Hex.toString((byte[])format) + " (hex)");
        }
        int length = bytes.length - 1;
        int elements = length / 2;
        if (length != elements * 2) {
            throw new IllegalArgumentException(String.format("Invalid EC point data: expected %s bytes, found %s bytes", 2 * elements, length));
        }
        byte[] xp = new byte[elements];
        byte[] yp = new byte[elements];
        System.arraycopy(bytes, 1, xp, 0, elements);
        System.arraycopy(bytes, 1 + elements, yp, 0, elements);
        BigInteger x = new BigInteger(1, xp);
        BigInteger y = new BigInteger(1, yp);
        return new ECPoint(x, y);
    }

    public static byte[] fromEcPoint(ECPoint point) {
        byte[] xp = OpenSSHPrivateKey.normalize(point.getAffineX().toByteArray());
        byte[] yp = OpenSSHPrivateKey.normalize(point.getAffineY().toByteArray());
        byte[] bytes = new byte[1 + xp.length + yp.length];
        bytes[0] = 4;
        System.arraycopy(xp, 0, bytes, 1, xp.length);
        System.arraycopy(yp, 0, bytes, 1 + xp.length, yp.length);
        return bytes;
    }

    private static byte[] normalize(byte[] bytes) {
        if (bytes.length % 8 == 0) {
            return bytes;
        }
        if (bytes[0] != 0) {
            throw new IllegalStateException();
        }
        byte[] trim = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, trim, 0, trim.length);
        return OpenSSHPrivateKey.normalize(trim);
    }

    public static void assertString(String name, String expected, String actual) {
        if (!expected.equals(actual)) {
            throw new IllegalArgumentException(String.format("Expected %s of '%s'. Found '%s'", name, expected, actual));
        }
    }

    public static void assertInt(String name, int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException(String.format("Expected %s of '%s'. Found '%s'", name, expected, actual));
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

