/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ssh;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.dsa.Dsa;
import org.tomitribe.churchkey.ec.Curve;
import org.tomitribe.churchkey.ec.ECParameterSpecs;
import org.tomitribe.churchkey.ec.Ecdsa;
import org.tomitribe.churchkey.ec.UnsupportedCurveException;
import org.tomitribe.churchkey.rsa.Rsa;
import org.tomitribe.churchkey.ssh.KeyInput;
import org.tomitribe.churchkey.ssh.KeyOutput;
import org.tomitribe.churchkey.ssh.OpenSSHParser;
import org.tomitribe.churchkey.ssh.OpenSSHPrivateKey;
import org.tomitribe.churchkey.util.Utils;

public class OpenSSHPublicKey
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        if (!Utils.startsWith("ssh-", bytes) && !Utils.startsWith("ecdsa-", bytes)) {
            return null;
        }
        try {
            KeyInput reader;
            String algorithm;
            String[] parts = new String(bytes, StandardCharsets.UTF_8).split(" +");
            byte[] encoded = parts[1].trim().getBytes();
            byte[] unencoded = Base64.getDecoder().decode(encoded);
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (parts.length == 3) {
                attributes.put("Comment", parts[2].trim());
            }
            if ((algorithm = (reader = new KeyInput(unencoded)).readString()).equals("ssh-rsa")) {
                return new Key(RsaPublic.read(reader), Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.OPENSSH, attributes);
            }
            if (algorithm.equals("ssh-dss")) {
                return new Key(DsaPublic.read(reader), Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.OPENSSH, attributes);
            }
            if (algorithm.startsWith("ecdsa-sha2-")) {
                return new Key(EcPublic.read(reader), Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.OPENSSH, attributes);
            }
            throw new UnsupportedOperationException("Unsupported key type: " + algorithm);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public byte[] encode(Key key) {
        java.security.Key publicKey = key.getKey();
        String comment = key.getAttributes().containsKey("Comment") ? " " + key.getAttribute("Comment") : "";
        try {
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                String encodedKey = OpenSSHParser.base64(RsaPublic.write(rsaPublicKey));
                return String.format("ssh-rsa %s%s%n", encodedKey, comment).getBytes();
            }
            if (publicKey instanceof DSAPublicKey) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                String encodedKey = OpenSSHParser.base64(DsaPublic.write(dSAPublicKey));
                return String.format("ssh-dss %s%s%n", encodedKey, comment).getBytes();
            }
            if (publicKey instanceof ECPublicKey) {
                ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
                String curveName = EcPublic.curveName(ecPublicKey.getParams());
                String encodedKey = OpenSSHParser.base64(EcPublic.write(ecPublicKey, curveName));
                return String.format("ecdsa-sha2-%s %s%s%n", curveName, encodedKey, comment).getBytes();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to encode key", e);
        }
        throw new UnsupportedOperationException("PublicKey type unsupported: " + publicKey.getClass().getName());
    }

    static class EcPublic {
        EcPublic() {
        }

        static PublicKey read(KeyInput key) throws IOException {
            String curveName = key.readString();
            Curve curve = Curve.resolve(curveName);
            byte[] bytes = key.readBytes();
            ECPoint point = OpenSSHPrivateKey.getEcPoint(bytes);
            return Ecdsa.Public.builder().curve(curve).y(point.getAffineY()).x(point.getAffineX()).build().toKey();
        }

        static byte[] write(ECPublicKey key, String curveName) throws IOException {
            KeyOutput out = new KeyOutput();
            out.writeString("ecdsa-sha2-" + curveName);
            out.writeString(curveName);
            out.writeBytes(OpenSSHPrivateKey.fromEcPoint(key.getW()));
            return out.toByteArray();
        }

        private static String curveName(ECParameterSpec spec) {
            if (Curve.nistp256.isEqual(spec)) {
                return Curve.nistp256.name();
            }
            if (Curve.nistp384.isEqual(spec)) {
                return Curve.nistp384.name();
            }
            if (Curve.nistp521.isEqual(spec)) {
                return Curve.nistp521.name();
            }
            for (Curve curve : Curve.values()) {
                if (!curve.isEqual(spec)) continue;
                Optional<Curve> nistAlias = curve.getAliases().stream().filter(curve1 -> curve1.name().startsWith("nist")).findFirst();
                return nistAlias.orElse(curve).name();
            }
            String s = ECParameterSpecs.toString(spec);
            throw new UnsupportedCurveException(String.format("The specified ECParameterSpec has no known name.  Params:%n%s", s));
        }
    }

    static class DsaPublic {
        DsaPublic() {
        }

        static PublicKey read(KeyInput key) throws IOException {
            return Dsa.Public.builder().p(key.readBigInteger()).q(key.readBigInteger()).g(key.readBigInteger()).y(key.readBigInteger()).build().toKey();
        }

        static byte[] write(DSAPublicKey key) throws IOException {
            KeyOutput out = new KeyOutput();
            out.writeString("ssh-dss");
            out.writeBigInteger(key.getParams().getP());
            out.writeBigInteger(key.getParams().getQ());
            out.writeBigInteger(key.getParams().getG());
            out.writeBigInteger(key.getY());
            return out.toByteArray();
        }
    }

    static class RsaPublic {
        RsaPublic() {
        }

        static PublicKey read(KeyInput keyInput) throws IOException {
            return Rsa.Public.builder().publicExponent(keyInput.readBigInteger()).modulus(keyInput.readBigInteger()).build().toKey();
        }

        static byte[] write(RSAPublicKey key) throws IOException {
            KeyOutput out = new KeyOutput();
            out.writeString("ssh-rsa");
            out.writeBigInteger(key.getPublicExponent());
            out.writeBigInteger(key.getModulus());
            return out.toByteArray();
        }
    }
}

