/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ssh;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.PublicKey;
import org.tomitribe.churchkey.Decoder;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.ssh.KeyInput;
import org.tomitribe.churchkey.ssh.OpenSSHPublicKey;
import org.tomitribe.churchkey.util.Pem;
import org.tomitribe.churchkey.util.Utils;

public class SSH2Parser
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        return new Ssh2PublicKeyDecoder().decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        return new byte[0];
    }

    public static class Ssh2PublicKeyDecoder
    implements Decoder {
        @Override
        public Key decode(byte[] key) {
            if (!Utils.startsWith("---- BEGIN SSH2 PUBLIC KEY ----", key)) {
                return null;
            }
            Pem pem = Pem.parse(key);
            try {
                KeyInput reader = new KeyInput(pem.getData());
                String algorithm = reader.readString();
                if (algorithm.equals("ssh-rsa")) {
                    PublicKey publicKey = OpenSSHPublicKey.RsaPublic.read(reader);
                    return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.SSH2, pem.getAttributes());
                }
                if (algorithm.equals("ssh-dss")) {
                    PublicKey publicKey = OpenSSHPublicKey.DsaPublic.read(reader);
                    return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.SSH2, pem.getAttributes());
                }
                throw new UnsupportedOperationException("Unsupported key type: " + algorithm);
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

