/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey;

import org.tomitribe.churchkey.jwk.JwkParser;
import org.tomitribe.churchkey.pem.PemParser;
import org.tomitribe.churchkey.ssh.OpenSSHParser;
import org.tomitribe.churchkey.ssh.SSH2Parser;

public class Key {
    private final java.security.Key key;
    private final Type type;
    private final Algorithm algorithm;
    private final Format format;

    public Key(java.security.Key key, Type type, Algorithm algorithm, Format format) {
        this.key = key;
        this.type = type;
        this.algorithm = algorithm;
        this.format = format;
    }

    public java.security.Key getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Format getFormat() {
        return this.format;
    }

    public static enum Format {
        JWK(new JwkParser()),
        OPENSSH(new OpenSSHParser()),
        SSH2(new SSH2Parser()),
        PEM(new PemParser());

        private final Parser parser;

        private Format(Parser parser) {
            this.parser = parser;
        }

        public byte[] encode(Key key) {
            return this.parser.encode(key);
        }

        public Key decode(byte[] bytes) {
            return this.parser.decode(bytes);
        }

        public static interface Parser {
            public Key decode(byte[] var1);

            public byte[] encode(Key var1);
        }
    }

    public static enum Algorithm {
        RSA,
        DSA,
        EC;

    }

    public static enum Type {
        PUBLIC,
        PRIVATE;

    }
}

