/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey;

import java.security.PublicKey;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.ssh.OpenSSHParser;

public class Keys {
    private Keys() {
    }

    public static Key decode(byte[] bytes) {
        for (Key.Format format : Key.Format.values()) {
            Key key = format.decode(bytes);
            if (key == null) continue;
            return key;
        }
        throw new IllegalArgumentException("Cannot decode key: " + new String(bytes));
    }

    public static byte[] encode(Key key) {
        return Keys.encode(key, key.getFormat());
    }

    public static byte[] encode(Key key, Key.Format format) {
        return format.encode(key);
    }

    public static PublicKey readPublicKey(byte[] bytes) {
        try {
            return OpenSSHParser.OpenSSH.readSshPublicKey(new String(bytes, "UTF-8"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

