/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.tomitribe.churchkey.Key;

public class BeginPublicKey {
    private BeginPublicKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPublicKey publicKey = (RSAPublicKey)factory.generatePublic(new X509EncodedKeySpec(bytes));
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("DSA");
            DSAPublicKey publicKey = (DSAPublicKey)factory.generatePublic(new X509EncodedKeySpec(bytes));
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("EC");
            ECPublicKey publicKey = (ECPublicKey)factory.generatePublic(new X509EncodedKeySpec(bytes));
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        throw new UnsupportedOperationException("Unsupported algorithm or invalid x509 key spec");
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

