/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.DerParser;

public class BeginRsaPrivateKey {
    private BeginRsaPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            DerParser parser = new DerParser(bytes);
            Asn1Object sequence = parser.read();
            if (sequence.getType() != 16) {
                throw new IllegalArgumentException("Invalid DER: not a sequence");
            }
            DerParser p = sequence.getParser();
            p.read();
            BigInteger modulus = p.read().getInteger();
            BigInteger publicExp = p.read().getInteger();
            BigInteger privateExp = p.read().getInteger();
            BigInteger prime1 = p.read().getInteger();
            BigInteger prime2 = p.read().getInteger();
            BigInteger exp1 = p.read().getInteger();
            BigInteger exp2 = p.read().getInteger();
            BigInteger crtCoef = p.read().getInteger();
            RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
            KeyFactory result = KeyFactory.getInstance("RSA");
            PrivateKey publicKey = result.generatePrivate(spec);
            return new Key(publicKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

