/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.jwk;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.Utils;
import org.tomitribe.churchkey.jwk.InvalidJwkException;
import org.tomitribe.churchkey.jwk.InvalidJwkKeySpecException;
import org.tomitribe.churchkey.jwk.MissingKtyException;
import org.tomitribe.churchkey.jwk.UnknownJsonFormatFoundException;
import org.tomitribe.churchkey.jwk.UnsupportedKtyAlgorithmException;
import org.tomitribe.util.IO;

public class JwkParser
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        byte[] decoded = this.normalize(bytes);
        if (!Utils.startsWith("{", decoded)) {
            return null;
        }
        String rawJson = new String(decoded);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.apache.johnzon.buffer-strategy", "BY_INSTANCE");
        JsonReaderFactory factory = Json.createReaderFactory(config);
        JsonReader reader = factory.createReader(IO.read((byte[])decoded));
        try {
            JsonObject jsonObject = reader.readObject();
            JsonObject jwk = this.getJwk(jsonObject);
            if (!jwk.containsKey((Object)"kty")) {
                throw new MissingKtyException();
            }
            String kty = jwk.getString("kty");
            if ("RSA".equals(kty)) {
                return this.asRsaKey(jwk);
            }
            throw new UnsupportedKtyAlgorithmException(kty);
        }
        catch (Exception e) {
            throw new InvalidJwkException(e, rawJson);
        }
    }

    private Key asRsaKey(JsonObject jwkObject) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Jwk jwk = new Jwk(jwkObject);
        BigInteger modulus = jwk.getBigInteger("n");
        BigInteger publicExp = jwk.getBigInteger("e");
        BigInteger privateExp = jwk.getBigInteger("d");
        BigInteger primeP = jwk.getBigInteger("p");
        BigInteger primeQ = jwk.getBigInteger("q");
        BigInteger primeExponentP = jwk.getBigInteger("dp");
        BigInteger primeExponentQ = jwk.getBigInteger("dq");
        BigInteger crtCoef = jwk.getBigInteger("qi");
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExp);
        RSAPrivateCrtKeySpec rsaPrivateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, primeP, primeQ, primeExponentP, primeExponentQ, crtCoef);
        this.checkPublicKey(rsaPublicKeySpec);
        this.checkPrivateKey(rsaPrivateKeySpec);
        KeyFactory result = KeyFactory.getInstance("RSA");
        if (privateExp != null) {
            PrivateKey privateKey = result.generatePrivate(rsaPrivateKeySpec);
            Map<String, String> attributes = this.getAttributes(jwkObject, "kty", "n", "e", "d", "p", "q", "dp", "dq", "qi");
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.JWK, attributes);
        }
        PublicKey publicKey = result.generatePublic(rsaPublicKeySpec);
        Map<String, String> attributes = this.getAttributes(jwkObject, "kty", "n", "e");
        return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.JWK, attributes);
    }

    private Map<String, String> getAttributes(JsonObject jwkObject, String ... excludes) {
        return this.getAttributes(jwkObject, Arrays.asList(excludes));
    }

    private Map<String, String> getAttributes(JsonObject jwkObject, Collection<String> excludes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : jwkObject.entrySet()) {
            if (excludes.contains(entry.getKey())) continue;
            map.put((String)entry.getKey(), this.toString((JsonValue)entry.getValue()));
        }
        return map;
    }

    private String toString(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                String string = value.toString();
                return string.substring(1, string.length() - 1);
            }
            case NULL: {
                return null;
            }
        }
        return value.toString();
    }

    private void checkPublicKey(RSAPublicKeySpec spec) {
        ArrayList<String> missing = new ArrayList<String>();
        if (spec.getModulus() == null) {
            missing.add("n");
        }
        if (spec.getPublicExponent() == null) {
            missing.add("e");
        }
        if (missing.size() > 0) {
            throw new InvalidJwkKeySpecException("rsa", missing);
        }
    }

    private void checkPrivateKey(RSAPrivateCrtKeySpec spec) {
        ArrayList<String> missing = new ArrayList<String>();
        if (spec.getPrivateExponent() == null) {
            missing.add("d");
        }
        if (spec.getPrimeP() == null) {
            missing.add("p");
        }
        if (spec.getPrimeQ() == null) {
            missing.add("q");
        }
        if (spec.getPrimeExponentP() == null) {
            missing.add("dp");
        }
        if (spec.getPrimeExponentQ() == null) {
            missing.add("dq");
        }
        if (spec.getCrtCoefficient() == null) {
            missing.add("qi");
        }
        if (missing.size() == 6) {
            return;
        }
        if (missing.size() == 0) {
            return;
        }
        throw new InvalidJwkKeySpecException("rsa", missing);
    }

    private JsonObject getJwk(JsonObject jsonObject) {
        if (jsonObject.containsKey((Object)"keys")) {
            return this.getJwkFromJwks(jsonObject);
        }
        if (jsonObject.containsKey((Object)"kty")) {
            return jsonObject;
        }
        throw new UnknownJsonFormatFoundException();
    }

    private JsonObject getJwkFromJwks(JsonObject jwks) {
        JsonValue keys = jwks.getValue("keys");
        if (keys == null) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is missing.");
        }
        switch (keys.getValueType()) {
            case ARRAY: {
                return this.getFirstJwk(jwks, keys.asJsonArray());
            }
            case OBJECT: {
                return keys.asJsonObject();
            }
        }
        throw new IllegalArgumentException("Invalid JWKS; 'keys' entry should be an array.");
    }

    private JsonObject getFirstJwk(JsonObject jwks, JsonArray keys) {
        if (keys.size() == 0) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is empty.\n" + jwks.toString());
        }
        JsonValue value = (JsonValue)keys.get(0);
        if (!JsonValue.ValueType.OBJECT.equals((Object)value.getValueType())) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' array should contain jwk objects.\n" + jwks.toString());
        }
        return value.asJsonObject();
    }

    private byte[] normalize(byte[] bytes) {
        if (!Utils.startsWith("e", bytes)) {
            return bytes;
        }
        return Base64.getUrlDecoder().decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        return new byte[0];
    }

    private static class Jwk {
        private final JsonObject jwk;

        public Jwk(JsonObject jwk) {
            this.jwk = jwk;
        }

        public BigInteger getBigInteger(String name) {
            if (!this.jwk.containsKey((Object)name)) {
                return null;
            }
            String string = this.jwk.getString(name);
            Base64.Decoder urlDecoder = Base64.getUrlDecoder();
            byte[] bytes = urlDecoder.decode(string);
            return new BigInteger(1, bytes);
        }
    }
}

