/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.DerParser;

public class BeginDsaPrivateKey {
    private BeginDsaPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            DerParser parser = new DerParser(bytes);
            Asn1Object sequence = parser.read();
            if (sequence.getType() != 16) {
                throw new IllegalArgumentException("Invalid DER: not a sequence");
            }
            DerParser parser1 = sequence.getParser();
            parser1.read();
            BigInteger p = parser1.read().getInteger();
            BigInteger q = parser1.read().getInteger();
            BigInteger g = parser1.read().getInteger();
            BigInteger unknown = parser1.read().getInteger();
            BigInteger x = parser1.read().getInteger();
            DSAPrivateKeySpec spec = new DSAPrivateKeySpec(x, p, q, g);
            KeyFactory result = KeyFactory.getInstance("DSA");
            PrivateKey publicKey = result.generatePrivate(spec);
            return new Key(publicKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

