/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.tomitribe.churchkey.Key;

public class BeginPrivateKey {
    private BeginPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPrivateKey privateKey = (RSAPrivateKey)factory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("DSA");
            DSAPrivateKey privateKey = (DSAPrivateKey)factory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("EC");
            ECPrivateKey privateKey = (ECPrivateKey)factory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        throw new UnsupportedOperationException("Unsupported algorithm or invalid PKCS#8 key spec");
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

