/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.tomitribe.churchkey.Decoder;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.Utils;
import org.tomitribe.churchkey.pem.BeginDsaPrivateKey;
import org.tomitribe.churchkey.pem.BeginPrivateKey;
import org.tomitribe.churchkey.pem.BeginPublicKey;
import org.tomitribe.churchkey.pem.BeginRsaPrivateKey;
import org.tomitribe.churchkey.pem.BeginRsaPublicKey;
import org.tomitribe.util.Base64;

public class PemParser
implements Key.Format.Parser {
    private final PemDecoder decoder = new PemDecoder();

    @Override
    public Key decode(byte[] bytes) {
        return this.decoder.decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        return new byte[0];
    }

    public static class PemDecoder
    implements Decoder {
        private final Map<String, Function<byte[], Key>> converters = new HashMap<String, Function<byte[], Key>>();

        public PemDecoder() {
            this.converters.put("PRIVATE KEY", BeginPrivateKey::decode);
            this.converters.put("PUBLIC KEY", BeginPublicKey::decode);
            this.converters.put("RSA PRIVATE KEY", BeginRsaPrivateKey::decode);
            this.converters.put("RSA PUBLIC KEY", BeginRsaPublicKey::decode);
            this.converters.put("DSA PRIVATE KEY", BeginDsaPrivateKey::decode);
        }

        @Override
        public Key decode(byte[] key) {
            if (!Utils.startsWith("-----", key)) {
                return null;
            }
            String s = new String(key);
            String[] parts = s.replaceAll(" *\n *", "").replaceAll(" *\r *", "").split("-----(BEGIN|END) |------?");
            Function<byte[], Key> converter = this.converters.get(parts[1]);
            if (converter == null) {
                throw new UnsupportedOperationException(String.format("Unsupported PEM format '%s'", parts[1]));
            }
            byte[] bytes = Base64.decodeBase64((byte[])parts[2].getBytes());
            return converter.apply(bytes);
        }
    }
}

