/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ssh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.Utils;

public class OpenSSHParser
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        if (!Utils.startsWith("ssh-", bytes)) {
            return null;
        }
        try {
            PublicKey publicKey = OpenSSH.readSshPublicKey(new String(bytes, "UTF-8"));
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey key = (RSAPublicKey)publicKey;
                return new Key(key, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.OPENSSH);
            }
            if (publicKey instanceof DSAPublicKey) {
                DSAPublicKey key = (DSAPublicKey)publicKey;
                return new Key(key, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.OPENSSH);
            }
            throw new UnsupportedOperationException("Unknown key type " + publicKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte[] encode(Key key) {
        return new byte[0];
    }

    public static class OpenSSH {
        public static String formatSshPublicKey(PublicKey publicKey, String comment) throws IOException {
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                String encodedKey = OpenSSH.base64(OpenSSH.encodeRsaPublicKey(rsaPublicKey));
                return String.format("ssh-rsa %s %s%n", encodedKey, comment);
            }
            if (publicKey instanceof DSAPublicKey) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                String encodedKey = OpenSSH.base64(OpenSSH.encodeDsaPublicKey(dSAPublicKey));
                return String.format("ssh-dss %s %s%n", encodedKey, comment);
            }
            throw new UnsupportedOperationException("PublicKey type unsupported: " + publicKey.getClass().getName());
        }

        private static String base64(byte[] src) {
            return Base64.getEncoder().encodeToString(src);
        }

        public static byte[] encodeRsaPublicKey(RSAPublicKey key) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OpenSSH.writeString(out, "ssh-rsa");
            OpenSSH.writeBigInt(out, key.getPublicExponent());
            OpenSSH.writeBigInt(out, key.getModulus());
            return out.toByteArray();
        }

        public static byte[] encodeDsaPublicKey(DSAPublicKey key) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OpenSSH.writeString(out, "ssh-dss");
            OpenSSH.writeBigInt(out, key.getParams().getP());
            OpenSSH.writeBigInt(out, key.getParams().getQ());
            OpenSSH.writeBigInt(out, key.getParams().getG());
            OpenSSH.writeBigInt(out, key.getY());
            return out.toByteArray();
        }

        private static void writeBigInt(OutputStream out, BigInteger m) throws IOException {
            OpenSSH.writeByteBlock(out, m.toByteArray());
        }

        private static void writeString(OutputStream out, String strign) throws IOException {
            OpenSSH.writeByteBlock(out, strign.getBytes("UTF-8"));
        }

        private static void writeByteBlock(OutputStream out, byte[] data) throws IOException {
            OpenSSH.encodeUInt32(data.length, out);
            out.write(data);
        }

        public static void encodeUInt32(int value, OutputStream out) throws IOException {
            byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
            out.write(tmp);
        }

        public static PublicKey readSshPublicKey(String sshPublicKeyFileContents) throws IOException, GeneralSecurityException {
            String[] parts = sshPublicKeyFileContents.split(" +");
            byte[] bytes1 = parts[1].getBytes();
            byte[] bytes = Base64.getDecoder().decode(bytes1);
            return OpenSSH.decode4253PublicKey(bytes);
        }

        public static PublicKey decode4253PublicKey(byte[] bytes1) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
            ByteArrayInputStream keyData = new ByteArrayInputStream(bytes1);
            String algorithm = OpenSSH.readString(keyData);
            if (algorithm.equals("ssh-rsa")) {
                return OpenSSH.readRsaPublicKey(keyData);
            }
            if (algorithm.equals("ssh-dss")) {
                return OpenSSH.readDsaPublicKey(keyData);
            }
            throw new UnsupportedOperationException("");
        }

        private static PublicKey readRsaPublicKey(InputStream keyData) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
            BigInteger e = OpenSSH.readBigInt(keyData);
            BigInteger n = OpenSSH.readBigInt(keyData);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(n, e);
            KeyFactory rsa = KeyFactory.getInstance("RSA");
            return rsa.generatePublic(keySpec);
        }

        private static PublicKey readDsaPublicKey(InputStream keyData) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
            BigInteger p = OpenSSH.readBigInt(keyData);
            BigInteger q = OpenSSH.readBigInt(keyData);
            BigInteger g = OpenSSH.readBigInt(keyData);
            BigInteger y = OpenSSH.readBigInt(keyData);
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory dsa = KeyFactory.getInstance("DSA");
            return dsa.generatePublic(keySpec);
        }

        public static BigInteger readBigInt(InputStream s) throws IOException {
            return new BigInteger(OpenSSH.readByteBlock(s));
        }

        public static String readString(InputStream s) throws IOException {
            return new String(OpenSSH.readByteBlock(s));
        }

        private static byte[] readByteBlock(InputStream s) throws IOException {
            int len = OpenSSH.decodeInt(s);
            byte[] bytes = new byte[len];
            OpenSSH.readFully(s, bytes);
            return bytes;
        }

        private static int decodeInt(InputStream s) throws IOException {
            byte[] bytes = new byte[]{0, 0, 0, 0};
            OpenSSH.readFully(s, bytes);
            return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        }

        public static void readFully(InputStream input, byte[] buffer) throws IOException {
            OpenSSH.readFully(input, buffer, 0, buffer.length);
        }

        public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
            int actual = OpenSSH.read(input, buffer, offset, length);
            if (actual != length) {
                throw new EOFException("Premature EOF - expected=" + length + ", actual=" + actual);
            }
        }

        public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
            int remaining = length;
            int curOffset = offset;
            while (remaining > 0) {
                int count = input.read(buffer, curOffset, remaining);
                if (count == -1) {
                    return curOffset - offset;
                }
                remaining -= count;
                curOffset += count;
            }
            return length;
        }
    }
}

