/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ssh;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.tomitribe.churchkey.Decoder;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.Utils;
import org.tomitribe.churchkey.ssh.OpenSSHParser;
import org.tomitribe.util.Base64;

public class SSH2Parser
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        return new Ssh2PublicKeyDecoder().decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        return new byte[0];
    }

    public static class Ssh2PublicKeyDecoder
    implements Decoder {
        @Override
        public Key decode(byte[] key) {
            PublicKey publicKey;
            if (!Utils.startsWith("---- BEGIN SSH2 PUBLIC KEY ----", key)) {
                return null;
            }
            String s = new String(key);
            StringBuilder sb = new StringBuilder();
            for (String line : s.split("\r?\n")) {
                if (line.startsWith("---- ") || line.contains(":")) continue;
                sb.append(line);
            }
            byte[] bytes = Base64.decodeBase64((byte[])sb.toString().getBytes());
            try {
                publicKey = OpenSSHParser.OpenSSH.decode4253PublicKey(bytes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            if (publicKey instanceof RSAPublicKey) {
                return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.SSH2);
            }
            if (publicKey instanceof DSAPublicKey) {
                return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.SSH2);
            }
            return null;
        }
    }
}

