/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.time.Clock;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.logging.LogRecord;
import org.tomitribe.delorean.FluxCapacitor;
import org.tomitribe.delorean.Log;
import org.tomitribe.delorean.UpdateMethods;

public class Agent {
    private static Instrumentation instrumentation;

    private Agent() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        if (Agent.instrumentation != null) {
            return;
        }
        try {
            FluxCapacitor.install(instrumentation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Agent.initialize(agentArgs, instrumentation);
        Agent.instrumentation = instrumentation;
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if (Agent.instrumentation != null) {
            return;
        }
        Agent.initialize(agentArgs, instrumentation);
        Agent.instrumentation = instrumentation;
    }

    private static void initialize(String agentArgs, Instrumentation instrumentation) {
        try {
            Log.debug.set(Boolean.getBoolean("delorean.debug"));
            instrumentation.addTransformer(new Transformer(), true);
            Agent.retransform(instrumentation, Date.class, GregorianCalendar.class, Thread.class, Clock.class, Currency.class, Timer.class, LogRecord.class, ResourceBundle.class);
            Log.log("Agent installed successfully.", new Object[0]);
            boolean modifiableClass = instrumentation.isModifiableClass(System.class);
            System.out.println(modifiableClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Log.err("Agent installation failed %s", e.getMessage());
        }
    }

    private static void retransform(Instrumentation instrumentation, Class<?> ... clazzes) throws UnmodifiableClassException {
        for (Class<?> clazz : clazzes) {
            Agent.retransform(instrumentation, clazz);
        }
    }

    private static void retransform(Instrumentation instrumentation, Class<?> clazz) throws UnmodifiableClassException {
        if (instrumentation.isModifiableClass(clazz)) {
            Log.debug("Retransform %s", clazz);
            instrumentation.retransformClasses(clazz);
        } else {
            Log.err("Cannot be retransformed %s", clazz);
        }
    }

    public static class Transformer
    implements ClassFileTransformer {
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            try {
                return UpdateMethods.enhance(classfileBuffer, className);
            }
            catch (Throwable e) {
                return classfileBuffer;
            }
        }
    }
}

