/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarFile;
import org.tomitribe.delorean.Packages;
import org.tomitribe.delorean.RepackageApi;
import org.tomitribe.delorean.api.Delorean;
import org.tomitribe.delorean.api.Duration;
import org.tomitribe.delorean.api.Normalize;
import org.tomitribe.delorean.util.Archive;
import org.tomitribe.delorean.util.Bytecode;

public class FluxCapacitor {
    public static void install(Instrumentation instrumentation) throws IOException {
        Archive archive = new Archive();
        FluxCapacitor.add(archive, Delorean.class);
        FluxCapacitor.add(archive, Duration.class);
        FluxCapacitor.add(archive, Normalize.class);
        File jar = archive.toJar();
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(jar));
    }

    private static void add(Archive archive, Class<?> clazz) throws IOException {
        byte[] bytecode = RepackageApi.enhance(Bytecode.readClassFile(clazz), clazz.getName());
        String name = clazz.getName().replace('.', '/').replace(Packages.apiPackage, Packages.genPackage) + ".class";
        archive.add(name, bytecode);
    }
}

