/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean;

import org.tomitribe.delorean.api.Delorean;
import org.tomitribe.delorean.asm.Type;

public class Packages {
    public static final String from = "api";
    public static final String to = "gen";
    static final String apiPackage = Packages.getPackage(Delorean.class);
    static final String genPackage = apiPackage.replace("api", "gen");
    static final String genClass = Packages.relocate(Delorean.class);
    static final String apiClass = Delorean.class.getName().replace(".", "/");

    private Packages() {
    }

    public static String relocate(Class<?> clazz) {
        return clazz.getName().replace(".", "/").replace(from, to);
    }

    public static String getPackage(Class<?> clazz) {
        return clazz.getName().replace(clazz.getSimpleName(), "").replace(".", "/");
    }

    public static String[] replace(String[] ss) {
        if (ss == null) {
            return null;
        }
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = Packages.replace(ss[i]);
        }
        return ss;
    }

    public static String replace(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("$SwitchMap$")) {
            String before = "$SwitchMap$" + apiPackage.replace("/", "$");
            String after = "$SwitchMap$" + genPackage.replace("/", "$");
            return s.replace(before, after);
        }
        return s.replace(apiPackage, genPackage);
    }

    public static Type replace(Type s) {
        if (s == null) {
            return null;
        }
        return Type.getType(Packages.replace(s.getDescriptor()));
    }

    public static Object replaceObj(Object o) {
        if (o instanceof Type) {
            Type type = (Type)o;
            return Packages.replace(type);
        }
        if (o instanceof String) {
            String string = (String)o;
            return Packages.replace(string);
        }
        return o;
    }

    public static Object[] replaceObj(Object[] o) {
        if (o == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i] = Packages.replaceObj(o[i]);
        }
        return o;
    }
}

