/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean;

import org.tomitribe.delorean.Log;
import org.tomitribe.delorean.Packages;
import org.tomitribe.delorean.asm.ClassVisitor;
import org.tomitribe.delorean.asm.ClassWriter;
import org.tomitribe.delorean.asm.MethodVisitor;
import org.tomitribe.delorean.asm.Opcodes;
import org.tomitribe.delorean.util.Bytecode;

public class UpdateMethods
extends ClassVisitor
implements Opcodes {
    private int replaced;
    private String className;

    public UpdateMethods(ClassVisitor classVisitor) {
        super(589824, classVisitor);
    }

    public static byte[] enhance(byte[] bytes, String className) {
        try {
            Log.debug("Visit %s", className);
            ClassWriter cw = new ClassWriter(1);
            UpdateMethods updateMethods = new UpdateMethods(cw);
            Bytecode.read(bytes, updateMethods);
            if (updateMethods.getReplaced() > 0) {
                Log.log("Replaced %s System.currentTimeMillis usages in %s", updateMethods.getReplaced(), className);
            }
            return cw.toByteArray();
        }
        catch (Exception e) {
            Log.err("Enhance Failed for '%s' : %s %s", className, e.getClass().getName(), e.getMessage());
            e.printStackTrace();
            return bytes;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitor(589824, visitor){

            @Override
            public void visitMethodInsn(int i, String s, String s1, String s2, boolean b) {
                if (Packages.genClass.equals(UpdateMethods.this.className)) {
                    super.visitMethodInsn(i, s, s1, s2, b);
                    return;
                }
                if ("java/lang/System".equals(s) && "currentTimeMillis".equals(s1) && "()J".equals(s2)) {
                    UpdateMethods.this.replaced++;
                    super.visitMethodInsn(i, Packages.genClass, s1, s2, b);
                } else if (Packages.apiClass.equals(s)) {
                    super.visitMethodInsn(i, Packages.genClass, s1, s2, b);
                } else {
                    super.visitMethodInsn(i, s, s1, s2, b);
                }
            }
        };
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public int getReplaced() {
        return this.replaced;
    }
}

