/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean.api;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.tomitribe.delorean.api.Duration;

public class Delorean {
    private static final AtomicBoolean debug = new AtomicBoolean(false);
    private static final AtomicLong offset = new AtomicLong(0L);

    public static long currentTimeMillis() {
        return System.currentTimeMillis() + offset.get();
    }

    public static long actualTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getOffset() {
        return offset.get();
    }

    public static long addOffset(long delta) {
        return offset.addAndGet(delta);
    }

    public static void setOffset(long milliseconds) {
        offset.set(milliseconds);
    }

    public static void setOffset(String duration) {
        long time = Delorean.parse(duration);
        Delorean.log("Setting offset to '%s'", duration);
        offset.set(time);
    }

    public static long parse(String duration) {
        if ((duration = duration.trim()).endsWith(" ago")) {
            duration = duration.substring(0, duration.length() - 4);
            duration = duration.trim();
            Duration d = new Duration(duration);
            return d.getTime(TimeUnit.MILLISECONDS) * -1L;
        }
        Duration d = new Duration(duration);
        return d.getTime(TimeUnit.MILLISECONDS);
    }

    public static String join(String delimiter, Collection collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            sb.append(obj).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    private static void log(String format, Object ... details) {
        String message = String.format(format, details);
        System.out.printf("Delorean: %s%n", message);
    }

    static {
        debug.set(Boolean.getBoolean("delorean.debug"));
        Delorean.setOffset(System.getProperty("delorean.offset", "0 milliseconds"));
    }
}

