/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.tomitribe.delorean.api.Delorean;
import org.tomitribe.delorean.api.Normalize;

public class Duration
implements Comparable<Duration> {
    long time;
    TimeUnit unit;

    public Duration() {
    }

    public Duration(long time, TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    public Duration(String string) {
        this(string, null);
    }

    public Duration(String string, TimeUnit defaultUnit) {
        String[] strings = string.split(",| and ");
        Duration total = new Duration();
        for (String value : strings) {
            char c;
            int i;
            Duration part = new Duration();
            String s = value.trim();
            StringBuilder t = new StringBuilder();
            StringBuilder u = new StringBuilder();
            for (i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || i == 0 && c == '-'); ++i) {
                t.append(c);
            }
            if (t.length() == 0) {
                Duration.invalidFormat(s);
            }
            while (i < s.length() && Character.isWhitespace(c = s.charAt(i))) {
                ++i;
            }
            while (i < s.length()) {
                c = s.charAt(i);
                if (Character.isLetter(c)) {
                    u.append(c);
                } else {
                    Duration.invalidFormat(s);
                }
                ++i;
            }
            part.time = Integer.parseInt(t.toString());
            part.unit = Duration.parseUnit(u.toString());
            if (part.unit == null) {
                part.unit = defaultUnit;
            }
            total = total.add(part);
        }
        this.time = total.time;
        this.unit = total.unit;
    }

    public long getTime(TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration that = (Duration)o;
        Normalize n = new Normalize(this, that);
        return n.a == n.b;
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public Duration add(Duration that) {
        Normalize n = new Normalize(this, that);
        return new Duration(n.a + n.b, n.base);
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal duration format: '" + text + "'.  Valid examples are '10s' or '10 seconds'.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.time);
        if (this.unit != null) {
            sb.append(" ");
            sb.append((Object)this.unit);
        }
        return sb.toString();
    }

    private static TimeUnit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if ("NANOSECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANOSECOND".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANOS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NANO".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("NS".equalsIgnoreCase(u)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("MICROSECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICROSECOND".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICROS".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MICRO".equalsIgnoreCase(u)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("MILLISECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLISECOND".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLIS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MILLI".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("MS".equalsIgnoreCase(u)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("SECONDS".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("SECOND".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("SEC".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("S".equalsIgnoreCase(u)) {
            return TimeUnit.SECONDS;
        }
        if ("MINUTES".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("MINUTE".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("MIN".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("M".equalsIgnoreCase(u)) {
            return TimeUnit.MINUTES;
        }
        if ("HOURS".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HOUR".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HRS".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("HR".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("H".equalsIgnoreCase(u)) {
            return TimeUnit.HOURS;
        }
        if ("DAYS".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        if ("DAY".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        if ("D".equalsIgnoreCase(u)) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown time unit '" + u + "'.  Supported units " + Delorean.join(", ", Duration.lowercase(TimeUnit.values())));
    }

    @Override
    public int compareTo(Duration that) {
        Normalize n = new Normalize(this, that);
        if (n.a > n.b) {
            return 1;
        }
        if (n.a == n.b) {
            return 0;
        }
        return -1;
    }

    private static List<String> lowercase(Enum ... units) {
        ArrayList<String> list = new ArrayList<String>();
        for (Enum unit : units) {
            list.add(unit.name().toLowerCase());
        }
        return list;
    }
}

