/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean.util;

import java.io.IOException;
import java.net.URL;
import org.tomitribe.delorean.asm.ClassReader;
import org.tomitribe.delorean.asm.ClassVisitor;
import org.tomitribe.delorean.util.IO;

public class Bytecode {
    private Bytecode() {
    }

    public static byte[] readClassFile(Class clazz) throws IOException {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return Bytecode.readClassFile(classLoader, clazz);
    }

    public static byte[] readClassFile(ClassLoader classLoader, Class clazz) throws IOException {
        String internalName = clazz.getName().replace('.', '/') + ".class";
        URL resource = classLoader.getResource(internalName);
        return IO.readBytes(resource);
    }

    public static byte[] readClassFile(ClassLoader classLoader, String className) throws IOException {
        String internalName = className.replace('.', '/') + ".class";
        URL resource = classLoader.getResource(internalName);
        return IO.readBytes(resource);
    }

    public static void read(byte[] originalBytes, ClassVisitor classAdapter) {
        if (originalBytes == null) {
            throw new IllegalStateException("bytecode array is null");
        }
        ClassReader cr = new ClassReader(originalBytes);
        cr.accept(classAdapter, 8);
    }
}

