/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.delorean.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Files {
    static final List<String> delete = new ArrayList<String>();

    public static void remove(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                Files.remove(child);
            }
        }
        if (!file.delete()) {
            throw new IllegalStateException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    public static File tmpdir() {
        try {
            File file = null;
            try {
                file = File.createTempFile("temp", "dir");
            }
            catch (Throwable e) {
                File tmp = new File("tmp");
                if (!tmp.exists() && !tmp.mkdirs()) {
                    throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
                }
                file = File.createTempFile("temp", "dir", tmp);
            }
            if (!file.delete()) {
                throw new IOException("Failed to create temp dir. Delete failed");
            }
            Files.mkdir(file);
            Files.deleteOnExit(file);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File mkdir(File file) {
        if (file.exists()) {
            return file;
        }
        if (!file.mkdirs()) {
            throw new RuntimeException("Cannot mkdir: " + file.getAbsolutePath());
        }
        return file;
    }

    public static void deleteOnExit(File file) {
        delete.add(file.getAbsolutePath());
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Files.class.getClassLoader());
        try {
            Thread deleteShutdownHook = new Thread(){

                @Override
                public void run() {
                    for (String path : delete) {
                        try {
                            Files.remove(new File(path));
                        }
                        catch (Throwable e) {
                            System.err.println(e.getMessage());
                        }
                    }
                }
            };
            try {
                Runtime.getRuntime().addShutdownHook(deleteShutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }
}

