/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.hodao.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.tomitribe.hodao.Find;
import org.tomitribe.hodao.MaxResults;
import org.tomitribe.hodao.Merge;
import org.tomitribe.hodao.NamedQuery;
import org.tomitribe.hodao.Offset;
import org.tomitribe.hodao.Optional;
import org.tomitribe.hodao.Persist;
import org.tomitribe.hodao.QueryParam;
import org.tomitribe.hodao.QueryString;
import org.tomitribe.hodao.Remove;
import org.tomitribe.hodao.ValidationException;
import org.tomitribe.hodao.util.Parameter;
import org.tomitribe.hodao.util.Reflection;

public class PersistenceHandler {
    private PersistenceHandler() {
    }

    public static Object invoke(EntityManager em, Method method, Object[] args) throws Throwable {
        if (method.isAnnotationPresent(NamedQuery.class)) {
            return PersistenceHandler.invokeNamedQuery(em, method, args);
        }
        if (method.isAnnotationPresent(QueryString.class)) {
            return PersistenceHandler.invokeQueryString(em, method, args);
        }
        if (method.isAnnotationPresent(Find.class)) {
            return PersistenceHandler.findByPrimaryKey(em, method, args);
        }
        if (method.isAnnotationPresent(Merge.class)) {
            return PersistenceHandler.merge(em, method, args);
        }
        if (method.isAnnotationPresent(Remove.class)) {
            return PersistenceHandler.remove(em, method, args);
        }
        if (method.isAnnotationPresent(Persist.class)) {
            return PersistenceHandler.persist(em, method, args);
        }
        throw new AbstractMethodError("No handler logic for method: " + method.toString());
    }

    public static Object persist(EntityManager em, Method method, Object[] args) throws Throwable {
        Class<?> entityClass = method.getParameterTypes()[0];
        Object entity = args[0];
        if (entity == null) {
            throw new ValidationException(entityClass.getSimpleName() + " object is null");
        }
        em.persist(entity);
        if (PersistenceHandler.isVoid(method.getReturnType())) {
            return null;
        }
        return entity;
    }

    public static Object findByPrimaryKey(EntityManager em, Method method, Object[] args) throws Throwable {
        Class<?> entityClass = method.getReturnType();
        Object primaryKey = args[0];
        if (primaryKey == null) {
            throw new ValidationException("Invalid id");
        }
        return em.find(entityClass, primaryKey);
    }

    public static Object invokeNamedQuery(EntityManager em, Method method, Object[] args) throws Throwable {
        NamedQuery namedQuery = method.getAnnotation(NamedQuery.class);
        Query query = em.createNamedQuery(namedQuery.value());
        if (namedQuery.update()) {
            return PersistenceHandler.update(method, args, query);
        }
        return PersistenceHandler.select(method, args, query);
    }

    public static Object invokeQueryString(EntityManager em, Method method, Object[] args) throws Throwable {
        QueryString queryString = method.getAnnotation(QueryString.class);
        Query query = em.createQuery(queryString.value());
        if (queryString.update()) {
            return PersistenceHandler.update(method, args, query);
        }
        return PersistenceHandler.select(method, args, query);
    }

    private static Object select(Method method, Object[] args, Query query) {
        boolean optional = method.getAnnotation(Optional.class) != null;
        Integer offset = null;
        Integer maxResults = null;
        for (Parameter parameter : Reflection.params(method, args)) {
            MaxResults m;
            Offset o;
            QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
            if (queryParam != null) {
                if (parameter.getValue() == null) {
                    throw new ValidationException(queryParam.value() + " is null");
                }
                query.setParameter(queryParam.value(), parameter.getValue());
            }
            if ((o = parameter.getAnnotation(Offset.class)) != null && PersistenceHandler.isInt(parameter.getType())) {
                offset = (Integer)parameter.getValue();
            }
            if ((m = parameter.getAnnotation(MaxResults.class)) == null || !PersistenceHandler.isInt(parameter.getType())) continue;
            maxResults = (Integer)parameter.getValue();
        }
        if (offset != null && maxResults != null) {
            query.setFirstResult(offset.intValue());
            query.setMaxResults(maxResults.intValue());
        }
        try {
            return PersistenceHandler.isList(method) ? query.getResultList() : query.getSingleResult();
        }
        catch (NoResultException e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private static Object update(Method method, Object[] args, Query query) {
        for (Parameter parameter : Reflection.params(method, args)) {
            QueryParam queryParam = parameter.getAnnotation(QueryParam.class);
            if (queryParam == null) continue;
            if (parameter.getValue() == null) {
                throw new ValidationException(queryParam.value() + " is null");
            }
            query.setParameter(queryParam.value(), parameter.getValue());
        }
        if (PersistenceHandler.isInt(method.getReturnType())) {
            return query.executeUpdate();
        }
        if (PersistenceHandler.isVoid(method.getReturnType())) {
            query.executeUpdate();
            return null;
        }
        throw new IllegalArgumentException("Update methods must have a void or int return type");
    }

    public static Object merge(EntityManager em, Method method, Object[] args) throws Throwable {
        Class<?> entityClass = method.getParameterTypes()[0];
        Object entity = args[0];
        if (entity == null) {
            throw new ValidationException(entityClass.getSimpleName() + " object is null");
        }
        return em.merge(entity);
    }

    public static Object remove(EntityManager em, Method method, Object[] args) throws Throwable {
        Class<?> entityClass = method.getParameterTypes()[0];
        Object entity = args[0];
        if (entity == null) {
            throw new ValidationException(entityClass.getSimpleName() + " object is null");
        }
        em.remove(em.merge(entity));
        return null;
    }

    private static boolean isList(Method method) {
        return Collection.class.isAssignableFrom(method.getReturnType());
    }

    private static boolean isInt(Class<?> clazz) {
        return Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz);
    }

    private static boolean isVoid(Class<?> clazz) {
        return Void.class.equals(clazz) || Void.TYPE.equals(clazz);
    }
}

