/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.common;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.inget.common.Configuration;
import org.tomitribe.inget.common.CustomTypeSolver;
import org.tomitribe.inget.common.Header;
import org.tomitribe.inget.common.ImportManager;
import org.tomitribe.inget.common.Reformat;
import org.tomitribe.inget.common.RemoveDuplicateImports;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class Utils {
    private Utils() {
    }

    public static ClassOrInterfaceDeclaration getClazz(CompilationUnit unit) {
        return unit.getTypes().stream().filter(typeDeclaration -> typeDeclaration instanceof ClassOrInterfaceDeclaration).findFirst().orElse(null);
    }

    public static Map<String, MemberValuePair> pairs(NormalAnnotationExpr annotation) {
        LinkedHashMap<String, MemberValuePair> map = new LinkedHashMap<String, MemberValuePair>();
        for (MemberValuePair pair : annotation.getPairs()) {
            map.put(pair.getNameAsString(), pair);
        }
        return map;
    }

    public static boolean isResourceMethod(MethodDeclaration method) {
        return Utils.httpMethod(method) != null;
    }

    public static boolean isGET(MethodDeclaration method) {
        return "GET".equals(Utils.httpMethod(method));
    }

    public static boolean isPUT(MethodDeclaration method) {
        return "PUT".equals(Utils.httpMethod(method));
    }

    public static boolean isPOST(MethodDeclaration method) {
        return "POST".equals(Utils.httpMethod(method));
    }

    public static boolean isDELETE(MethodDeclaration method) {
        return "DELETE".equals(Utils.httpMethod(method));
    }

    public static boolean isHEAD(MethodDeclaration method) {
        return "HEAD".equals(Utils.httpMethod(method));
    }

    public static boolean isOPTIONS(MethodDeclaration method) {
        return "OPTIONS".equals(Utils.httpMethod(method));
    }

    public static boolean isPATCH(MethodDeclaration method) {
        return "PATCH".equals(Utils.httpMethod(method));
    }

    public static String httpMethod(MethodDeclaration method) {
        List<String> methods = Arrays.asList("POST", "PUT", "GET", "DELETE", "OPTIONS", "HEAD", "PATCH");
        for (String m : methods) {
            if (!method.getAnnotationByName(m).isPresent()) continue;
            return m;
        }
        return null;
    }

    public static NormalAnnotationExpr getOperation(MethodDeclaration method) {
        return Utils.getAnnotation(method, "Operation");
    }

    public static NormalAnnotationExpr getAnnotation(MethodDeclaration method, String annotationName) {
        Optional annotationByName = method.getAnnotationByName(annotationName);
        if (annotationByName.isPresent() && ((AnnotationExpr)annotationByName.get()).isSingleMemberAnnotationExpr()) {
            SingleMemberAnnotationExpr singleAnnotation = ((AnnotationExpr)annotationByName.get()).asSingleMemberAnnotationExpr();
            NodeList nodeList = new NodeList();
            nodeList.add((Node)new MemberValuePair("value", singleAnnotation.getMemberValue()));
            return new NormalAnnotationExpr(((AnnotationExpr)annotationByName.get()).getName(), nodeList);
        }
        return annotationByName.orElse(null);
    }

    public static <N extends Node> void sortNodes(NodeList<N> ns, Function<N, String> classifier, String ... patterns) {
        ns.sort(Comparator.comparing(annotation -> Utils.sort((String)classifier.apply(annotation), patterns)));
    }

    private static int sort(String name, String ... patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!name.matches(patterns[i])) continue;
            return i;
        }
        return patterns.length + 1;
    }

    public static void addApiResponse(MethodDeclaration method, int code, String message, Header header) {
        CompilationUnit unit = (CompilationUnit)method.findCompilationUnit().get();
        unit.addImport("io.swagger.v3.oas.annotations.responses.ApiResponses");
        unit.addImport("io.swagger.v3.oas.annotations.responses.ApiResponse");
        NormalAnnotationExpr apiResponses = Utils.getAnnotation(method, "ApiResponses");
        String headerString = "";
        if (header != null) {
            unit.addImport("io.swagger.v3.oas.annotations.headers.Header");
            headerString = ", headers = {@Header(name = \"" + header.getName() + "\", description = \"" + header.getDescription() + "\")}";
        }
        String response = "@ApiResponse(responseCode = \"" + code + "\", description = \"" + message + "\"" + headerString + ")";
        if (apiResponses == null) {
            method.addAnnotation(JavaParser.parseAnnotation((String)("@ApiResponses( value = {" + response + "})")));
            return;
        }
        MemberValuePair value = Utils.pairs(apiResponses).get("value");
        if (value == null) {
            apiResponses.addPair("value", "{" + response + "}");
            return;
        }
        NodeList<NormalAnnotationExpr> annotations = Utils.arrayValue(value.getValue());
        boolean has409 = annotations.stream().anyMatch(Utils.has("responseCode", "\"" + code + "\""));
        if (!has409) {
            annotations.add((Node)((NormalAnnotationExpr)JavaParser.parseAnnotation((String)response)));
            ArrayInitializerExpr value1 = Utils.asArray(annotations);
            value.setValue((Expression)value1);
        }
    }

    private static ArrayInitializerExpr asArray(NodeList<? extends Expression> annotations) {
        NodeList expressions = new NodeList();
        expressions.addAll(annotations);
        return new ArrayInitializerExpr(expressions);
    }

    public static Predicate<NormalAnnotationExpr> has(String member, String value) {
        return normalAnnotationExpr -> Utils.has(normalAnnotationExpr, member, value);
    }

    public static boolean has(NormalAnnotationExpr normalAnnotationExpr, String member, String value) {
        if (normalAnnotationExpr == null) {
            return false;
        }
        Map<String, MemberValuePair> pairs = Utils.pairs(normalAnnotationExpr);
        MemberValuePair code = pairs.get(member);
        return code != null && value.equals(code.getValue().toString());
    }

    public static NodeList<NormalAnnotationExpr> arrayValue(Expression expression) {
        NodeList annotations = new NodeList();
        if (expression instanceof ArrayInitializerExpr) {
            ArrayInitializerExpr arrayInitializerExpr = (ArrayInitializerExpr)expression;
            for (Expression exp2 : arrayInitializerExpr.getValues()) {
                annotations.add((Node)((NormalAnnotationExpr)exp2));
            }
        } else if (expression instanceof NormalAnnotationExpr) {
            annotations.add((Node)((NormalAnnotationExpr)expression));
        } else {
            throw new IllegalStateException("Unsupported Expression " + expression.getClass().getName());
        }
        return annotations;
    }

    public static void removeApiResponse(MethodDeclaration method, int code) {
        NormalAnnotationExpr apiResponses = Utils.getAnnotation(method, "ApiResponses");
        if (apiResponses == null) {
            return;
        }
        MemberValuePair value = Utils.pairs(apiResponses).get("value");
        if (value == null) {
            return;
        }
        NodeList<NormalAnnotationExpr> annotations = Utils.arrayValue(value.getValue());
        NormalAnnotationExpr match = annotations.stream().filter(Utils.has("responseCode", "\"" + code + "\"")).findFirst().orElse(null);
        if (match == null) {
            return;
        }
        if (annotations.size() > 1) {
            value.remove((Node)match);
            return;
        }
        apiResponses.remove((Node)value);
        if (apiResponses.getPairs().size() == 0) {
            method.getAnnotations().remove((Node)apiResponses);
        }
    }

    public static boolean hasPathParameter(MethodDeclaration method) {
        NormalAnnotationExpr path = Utils.getAnnotation(method, "Path");
        if (path == null) {
            return false;
        }
        MemberValuePair value = Utils.pairs(path).get("value");
        return value != null && value.toString().matches(".*\\{[^}]+\\}.*");
    }

    public static boolean isMethodReadAll(MethodDeclaration method) {
        NormalAnnotationExpr pathAnnotation = Utils.getAnnotation(method, "Path");
        boolean hasPathAnnotation = pathAnnotation != null;
        return Utils.isGET(method) && !hasPathAnnotation;
    }

    public static boolean isMethodRead(MethodDeclaration method, String idField) {
        boolean hasPathAnnotation;
        NormalAnnotationExpr pathAnnotation = Utils.getAnnotation(method, "Path");
        boolean bl = hasPathAnnotation = pathAnnotation != null;
        if (hasPathAnnotation) {
            boolean isMethodFind;
            Optional<MemberValuePair> valueId = pathAnnotation.getPairs().stream().filter(i -> i.getValue().toString().equals("\"{" + idField + "}\"") || i.getValue().toString().equals("\"{id}\"")).findFirst();
            boolean hasValueId = valueId.isPresent();
            boolean bl2 = isMethodFind = Utils.isGET(method) && hasPathAnnotation && hasValueId;
            if (isMethodFind) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodCreate(MethodDeclaration method) {
        NormalAnnotationExpr pathAnnotation = Utils.getAnnotation(method, "Path");
        boolean hasPathAnnotation = pathAnnotation != null;
        return Utils.isPOST(method) && !hasPathAnnotation && !Utils.isBulkMethod(method);
    }

    public static boolean isMethodUpdate(MethodDeclaration method, String idField) {
        boolean hasPathAnnotation;
        NormalAnnotationExpr pathAnnotation = Utils.getAnnotation(method, "Path");
        boolean bl = hasPathAnnotation = pathAnnotation != null;
        if (hasPathAnnotation) {
            boolean isMethodUpdate;
            Optional<MemberValuePair> valueId = pathAnnotation.getPairs().stream().filter(i -> i.getValue().toString().equals("\"{" + idField + "}\"") || i.getValue().toString().equals("\"{id}\"")).findFirst();
            boolean hasValueId = valueId.isPresent();
            boolean bl2 = isMethodUpdate = Utils.isPUT(method) && hasPathAnnotation && hasValueId;
            if (isMethodUpdate) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodDelete(MethodDeclaration method, String idField) {
        boolean hasPathAnnotation;
        NormalAnnotationExpr pathAnnotation = Utils.getAnnotation(method, "Path");
        boolean bl = hasPathAnnotation = pathAnnotation != null;
        if (hasPathAnnotation) {
            boolean isMethodDelete;
            Optional<MemberValuePair> valueId = pathAnnotation.getPairs().stream().filter(i -> i.getValue().toString().equals("\"{" + idField + "}\"") || i.getValue().toString().equals("\"{id}\"")).findFirst();
            boolean hasValueId = valueId.isPresent();
            boolean bl2 = isMethodDelete = Utils.isDELETE(method) && hasPathAnnotation && hasValueId;
            if (isMethodDelete) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodBulkCreate(MethodDeclaration method) {
        return Utils.isPOST(method) && Utils.isBulkMethod(method);
    }

    public static boolean isMethodBulkDelete(MethodDeclaration method) {
        return Utils.isDELETE(method) && Utils.isBulkMethod(method);
    }

    public static boolean isMethodBulkUpdate(MethodDeclaration method) {
        return Utils.isPUT(method) && Utils.isBulkMethod(method);
    }

    public static boolean isBulkMethod(MethodDeclaration m) {
        return m.getName().toString().startsWith("bulk");
    }

    public static boolean hasMethodInClass(ClassOrInterfaceDeclaration clazz, Predicate<MethodDeclaration> methodPredicate) {
        return clazz.getMethods().stream().anyMatch(methodPredicate);
    }

    public static ClassOrInterfaceDeclaration getExtendedClass(CompilationUnit classUnit, String extendedClassName) throws IOException {
        String extendedClassPath;
        Optional<ImportDeclaration> classImport = classUnit.getImports().stream().filter(i -> i.getNameAsString().endsWith("." + extendedClassName)).findFirst();
        if (classImport.isPresent()) {
            extendedClassPath = Configuration.modelSources + "/" + classImport.get().getNameAsString().replaceAll("\\.", "/");
            extendedClassPath = extendedClassPath + ".java";
        } else {
            extendedClassPath = Configuration.modelSources + "/" + ((PackageDeclaration)classUnit.getPackageDeclaration().get()).getNameAsString().replaceAll("\\.", "/");
            extendedClassPath = extendedClassPath + "/" + extendedClassName + ".java";
        }
        return Utils.getClazz(extendedClassPath);
    }

    public static ClassOrInterfaceDeclaration getClazz(String filePath) throws IOException {
        String source = IO.slurp((File)new File(filePath));
        CompilationUnit classUnit = JavaParser.parse((String)source);
        return Utils.getClazz(classUnit);
    }

    public static String getExample(FieldDeclaration field) {
        Optional fieldSchema = field.getAnnotationByName("Schema");
        if (!fieldSchema.isPresent()) {
            return null;
        }
        Map<String, MemberValuePair> pairs = Utils.pairs(((AnnotationExpr)fieldSchema.get()).asNormalAnnotationExpr());
        MemberValuePair example = pairs.get("example");
        if (example == null) {
            return null;
        }
        return example.getValue().asStringLiteralExpr().getValue();
    }

    public static boolean isId(FieldDeclaration field) {
        Optional modelAnnotation = field.getAnnotationByName("Model");
        if (!modelAnnotation.isPresent()) {
            return false;
        }
        Map<String, MemberValuePair> pairs = Utils.pairs(((AnnotationExpr)modelAnnotation.get()).asNormalAnnotationExpr());
        MemberValuePair id = pairs.get("id");
        return id != null && id.getValue().asBooleanLiteralExpr().getValue();
    }

    public static String getRootName(ClassOrInterfaceDeclaration rootClass) {
        return rootClass.getName().toString().replace(Configuration.modelSuffix, "");
    }

    public static boolean isRootResource(String rootClassName, String resourceName) {
        String expectedSingularResource = rootClassName + Configuration.resourceSuffix;
        return expectedSingularResource.equals(resourceName);
    }

    public static List<String> getClassOperations(ClassOrInterfaceDeclaration rootClass) {
        NodeList pairs;
        Optional<MemberValuePair> pair;
        AnnotationExpr modelAnnotation;
        List<String> classOperations = null;
        Optional classModel = rootClass.getAnnotationByName("Model");
        if (classModel.isPresent() && (modelAnnotation = (AnnotationExpr)classModel.get()).isNormalAnnotationExpr() && (pair = (pairs = modelAnnotation.asNormalAnnotationExpr().getPairs()).stream().filter(p -> p.getNameAsString().equals("operation")).findFirst()).isPresent()) {
            Expression value = pair.get().getValue();
            if (value.isArrayInitializerExpr()) {
                ArrayInitializerExpr values = value.asArrayInitializerExpr();
                classOperations = values.getValues().stream().map(Node::toString).collect(Collectors.toList());
            } else {
                FieldAccessExpr field = value.asFieldAccessExpr();
                classOperations = Collections.singletonList(field.toString());
            }
        }
        return classOperations;
    }

    public static List<File> getResources(String modelClassName) {
        File apiSourcesDir = new File(Configuration.resourceSources);
        File sourceRootDir = new File(Configuration.generatedSources);
        List src = Files.collect((File)apiSourcesDir, (String)("(.*)" + Configuration.resourceSuffix + "\\.java")).stream().filter(f -> f.getName().equals(modelClassName + Configuration.resourceSuffix + ".java") || f.getName().equals(Utils.toPlural(modelClassName) + Configuration.resourceSuffix + ".java")).collect(Collectors.toList());
        List generatedSources = Files.collect((File)sourceRootDir, (String)("(.*)" + Configuration.resourceSuffix + "\\.java")).stream().filter(f -> f.getName().equals(modelClassName + Configuration.resourceSuffix + ".java") || f.getName().equals(Utils.toPlural(modelClassName) + Configuration.resourceSuffix + ".java")).collect(Collectors.toList());
        return Stream.concat(src.stream(), generatedSources.stream()).distinct().collect(Collectors.toList());
    }

    public static Map<String, String> getResources() {
        File srcFolder = new File(Configuration.resourceSources);
        File generatedFolder = new File(Configuration.generatedSources);
        List src = Files.collect((File)srcFolder, (String)"(.*)\\.java");
        List generatedSources = Files.collect((File)generatedFolder, (String)"(.*)\\.java");
        Map<String, File> collect = Stream.concat(src.stream(), generatedSources.stream()).distinct().collect(Collectors.toMap(File::getName, f -> f));
        HashMap<String, String> resourcesMap = new HashMap<String, String>();
        for (Map.Entry<String, File> next : collect.entrySet()) {
            String content = null;
            try {
                content = IO.slurp((File)next.getValue());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (content == null || !content.contains("javax.ws.rs") || !content.contains("@Path")) continue;
            resourcesMap.put(next.getKey(), content);
        }
        return resourcesMap;
    }

    public static List<File> getModel() {
        if (Configuration.modelPackage != null) {
            File apiSourcesDir = new File(Configuration.getModelPath());
            return Files.collect((File)apiSourcesDir, (String)("(.*)" + Configuration.modelSuffix + "\\.java"));
        }
        return Collections.emptyList();
    }

    public static List<File> getClient() {
        File srcFolder = new File(Configuration.clientSources);
        return Files.collect((File)srcFolder, (String)"(.*)Client\\.java");
    }

    public static String getIdName(ClassOrInterfaceDeclaration rootClass) {
        Optional<FieldDeclaration> idField = Utils.getId(rootClass);
        if (idField.isPresent()) {
            return ((VariableDeclarator)idField.get().getVariables().stream().findFirst().get()).getName().asString();
        }
        return "id";
    }

    public static Optional<FieldDeclaration> getId(ClassOrInterfaceDeclaration rootClass) {
        return rootClass.getFields().stream().filter(f -> {
            NormalAnnotationExpr modelAnnotation;
            NodeList pairs;
            Optional<MemberValuePair> pair;
            Optional modelOptional = f.getAnnotationByName("Model");
            if (modelOptional.isPresent() && (pair = (pairs = (modelAnnotation = ((AnnotationExpr)modelOptional.get()).asNormalAnnotationExpr()).getPairs()).stream().filter(p -> p.getName().asString().equals("id")).findFirst()).isPresent()) {
                BooleanLiteralExpr booleanLiteralExpr = pair.get().getValue().asBooleanLiteralExpr();
                return booleanLiteralExpr.getValue();
            }
            return false;
        }).findFirst();
    }

    public static boolean isOperationPresent(FieldDeclaration f, String operation) {
        Optional<MemberValuePair> valuePair = f.getAnnotations().stream().filter(a -> a.getName().toString().equals("Model")).map(a -> a.asNormalAnnotationExpr().getPairs()).flatMap(Collection::stream).filter(a -> a.getName().toString().equals("operation")).findFirst();
        if (valuePair.isPresent()) {
            if (valuePair.get().getValue().isFieldAccessExpr()) {
                return valuePair.get().getValue().toString().contains(operation);
            }
            NodeList values = valuePair.get().getValue().asArrayInitializerExpr().getValues();
            return values.stream().map(Node::toString).anyMatch(v -> v.equals(operation));
        }
        return false;
    }

    public static boolean hasOperations(FieldDeclaration f) {
        return f.getAnnotations().stream().filter(a -> a.getName().toString().equals("Model")).map(a -> a.asNormalAnnotationExpr().getPairs()).flatMap(Collection::stream).anyMatch(a -> a.getName().toString().equals("operation"));
    }

    public static String toPlural(String singular) {
        if (singular == null) {
            return null;
        }
        if (!singular.endsWith("y")) {
            singular = singular + "s";
            return singular;
        }
        String beforeTwoChars = singular.substring(0, singular.length() - 2);
        String twoLastChars = singular.substring(singular.length() - 2, singular.length());
        String beforeY = twoLastChars.substring(0, 1);
        String plural = "";
        plural = beforeY.equals("a") || beforeY.equals("e") || beforeY.equals("i") || beforeY.equals("o") || beforeY.equals("u") ? plural + beforeTwoChars + twoLastChars + "s" : plural + beforeTwoChars + beforeY + "ies";
        return plural;
    }

    public static void addGeneratedAnnotation(CompilationUnit unit, ClassOrInterfaceDeclaration clazz, MethodDeclaration method, Class<?> generator) {
        Name name = new Name("Generated");
        StringLiteralExpr memberValue = new StringLiteralExpr(generator.getName());
        SingleMemberAnnotationExpr expr = new SingleMemberAnnotationExpr(name, (Expression)memberValue);
        unit.addImport(ImportManager.getImport("Generated"));
        if (clazz != null) {
            clazz.addAnnotation((AnnotationExpr)expr);
        } else if (method != null) {
            method.addAnnotation((AnnotationExpr)expr);
        }
    }

    public static String formatCamelCaseTo(String value, String separator) {
        Matcher matcher = Pattern.compile("(?<=[a-z])[A-Z]").matcher(value);
        StringBuffer modified = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(modified, separator + matcher.group());
        }
        matcher.appendTail(modified);
        return modified.toString().toLowerCase();
    }

    public static void addImports(CompilationUnit oldClassUnit, CompilationUnit newClassUnit) {
        oldClassUnit.getImports().forEach(arg_0 -> ((CompilationUnit)newClassUnit).addImport(arg_0));
    }

    public static void save(String fileName, String pkg, String content) throws IOException {
        Path path = Paths.get(Configuration.generatedSources + File.separator + Utils.transformPackageToPath(pkg), new String[0]);
        content = Stream.of(content).map(RemoveDuplicateImports::apply).map(Reformat::apply).findFirst().get();
        if (!java.nio.file.Files.exists(path, new LinkOption[0])) {
            java.nio.file.Files.createDirectories(path, new FileAttribute[0]);
        }
        File newFile = new File(path.toAbsolutePath().toString(), fileName);
        IO.copy((InputStream)IO.read((String)content), (File)newFile);
    }

    public static String transformPackageToPath(String pkg) {
        return pkg.replaceAll("\\.", File.separator);
    }

    public static void addLicense(CompilationUnit rootUnit, CompilationUnit newClassUnit) {
        Optional license = rootUnit.getComment();
        license.ifPresent(arg_0 -> ((CompilationUnit)newClassUnit).setComment(arg_0));
    }

    public static boolean isJaxRSAnnotation(AnnotationExpr a) {
        String importValue = ImportManager.getImport(a.getNameAsString());
        return importValue != null && importValue.contains("javax.ws.rs.");
    }

    public static String getResponseImplementation(MethodDeclaration m) {
        NormalAnnotationExpr apiResponses = Utils.getAnnotation(m, "ApiResponses");
        if (apiResponses == null) {
            return null;
        }
        MemberValuePair value = Utils.pairs(apiResponses).get("value");
        NodeList<NormalAnnotationExpr> annotations = Utils.arrayValue(value.getValue());
        Optional<NormalAnnotationExpr> responseOptional = annotations.stream().filter(a -> Utils.has(a, "responseCode", "\"200\"") || Utils.has(a, "responseCode", "\"201\"")).findFirst();
        if (responseOptional.isPresent()) {
            NormalAnnotationExpr response = responseOptional.get();
            Map<String, MemberValuePair> responsePairs = Utils.pairs(response);
            MemberValuePair contentPair = responsePairs.get("content");
            if (contentPair == null) {
                return null;
            }
            Expression content = contentPair.getValue();
            Map<String, MemberValuePair> contentPairs = Utils.pairs(content.asNormalAnnotationExpr());
            NormalAnnotationExpr schema = contentPairs.get("schema").getValue().asNormalAnnotationExpr();
            Map<String, MemberValuePair> schemaPairs = Utils.pairs(schema);
            Expression implementation = schemaPairs.get("implementation").getValue();
            return implementation.asClassExpr().getTypeAsString();
        }
        return null;
    }

    public static String getFullQualifiedName(CompilationUnit unit) {
        ClassOrInterfaceDeclaration clazz = Utils.getClazz(unit);
        return ((PackageDeclaration)unit.getPackageDeclaration().get()).getNameAsString() + "." + clazz.getNameAsString();
    }

    public static boolean isWrapperOrPrimitiveOrDate(FieldDeclaration f) {
        VariableDeclarator var = (VariableDeclarator)f.getVariables().stream().findFirst().get();
        boolean isWrapper = false;
        String type = var.getTypeAsString();
        if (type.contains("<")) {
            type = type.substring(type.indexOf("<") + 1, type.indexOf(">"));
        }
        try {
            type = type.startsWith("java.lang") ? type : "java.lang." + type;
            CustomTypeSolver.get().solveType(type);
            isWrapper = true;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        boolean isDate = false;
        try {
            CustomTypeSolver.get().solveType(type);
            if (type.startsWith("java.util")) {
                isDate = true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return f.getCommonType().isPrimitiveType() || isWrapper || isDate;
    }

    public static boolean isCollection(ResolvedType type) {
        ResolvedReferenceTypeDeclaration typeDeclaration;
        return type.isReferenceType() && (typeDeclaration = type.asReferenceType().getTypeDeclaration()).isAssignableBy(CustomTypeSolver.get().solveType("java.util.Collection"));
    }
}

