/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.tomitribe.inget.client.ClientGenerator;
import org.tomitribe.inget.cmd.CmdGenerator;
import org.tomitribe.inget.common.Authentication;
import org.tomitribe.inget.common.Configuration;
import org.tomitribe.inget.common.CustomTypeSolver;
import org.tomitribe.inget.common.Utils;
import org.tomitribe.inget.model.ModelGenerator;
import org.tomitribe.inget.resource.ResourcesGenerator;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class MainGenerator
extends AbstractMojo {
    @Parameter(property="generate.model_package", required=true)
    private String modelPackage;
    @Parameter(property="generate.resource_package")
    private String resourcePackage;
    @Parameter(property="generate.generate_model", defaultValue="false")
    private Boolean generateModel;
    @Parameter(property="generate.generate_resources", defaultValue="false")
    private Boolean generateResources;
    @Parameter(property="generate.generate_client", defaultValue="false")
    private Boolean generateClient;
    @Parameter(property="generate.generate_cli", defaultValue="false")
    private Boolean generateCli;
    @Parameter(property="generate.client_name", defaultValue="ResourceClient")
    private String clientName;
    @Parameter(property="generate.resource_suffix")
    private String resourceSuffix;
    @Parameter(property="generate.model_suffix", defaultValue="Model")
    private String modelSuffix;
    @Parameter(property="generate.cmdline_name")
    private String cmdLineName;
    @Parameter(property="generate.authentication")
    private String authentication;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.project.setArtifactFilter((ArtifactFilter)new AndArtifactFilter());
        Set artifacts = this.project.getArtifacts();
        String generatedSources = this.project.getBuild().getDirectory() + File.separator + "generated-sources";
        this.project.addCompileSourceRoot(generatedSources);
        Configuration.modelSources = this.project.getBuild().getSourceDirectory();
        Configuration.resourceSources = this.project.getBuild().getSourceDirectory();
        Configuration.generatedSources = generatedSources;
        Configuration.modelPackage = this.modelPackage;
        Configuration.resourcePackage = this.resourcePackage;
        Configuration.clientName = this.clientName;
        Configuration.resourceSuffix = this.resourceSuffix;
        Configuration.modelSuffix = this.modelSuffix;
        Configuration.tempSource = this.project.getBuild().getDirectory() + File.separator + "temp-source";
        Configuration.cmdLineName = this.cmdLineName != null ? this.cmdLineName : this.project.getArtifactId();
        if (this.authentication != null) {
            if (this.authentication.equalsIgnoreCase(Authentication.BASIC.name())) {
                Configuration.authentication = Authentication.BASIC;
            }
            if (this.authentication.equalsIgnoreCase(Authentication.SIGNATURE.name())) {
                Configuration.authentication = Authentication.SIGNATURE;
            }
        }
        try {
            this.generateModel(artifacts);
            this.generateResources(artifacts);
            FileUtils.mkdir((String)generatedSources);
            CustomTypeSolver.init();
            if (this.generateClient.booleanValue()) {
                this.requireResourcePackage();
                this.getLog().info((CharSequence)"Started Client Code Generation.");
                ClientGenerator.execute();
                this.getLog().info((CharSequence)"Finished Client Code Generation.");
                Configuration.clientSources = Configuration.generatedSources;
            }
            if (this.generateCli.booleanValue()) {
                boolean clientExistsInCurrentProject = new File(Configuration.getClientPath()).exists();
                if (clientExistsInCurrentProject) {
                    Configuration.clientSources = Configuration.getClientPath();
                } else {
                    List<Artifact> clientDependencies = artifacts.stream().filter(a -> this.hasClient(a.getFile())).collect(Collectors.toList());
                    if (clientDependencies.size() == 0) {
                        throw new MojoExecutionException("Clients were not found. Generate the client adding the 'resourcePackage' and 'generateClient' as true.");
                    }
                    clientDependencies.forEach(m -> this.extractJavaFiles(m.getFile()));
                    Configuration.resourceSources = Configuration.tempSource;
                    Configuration.clientSources = Configuration.tempSource;
                }
                Configuration.cmdPackage = Configuration.resourcePackage + ".cmd";
                this.getLog().info((CharSequence)"Started Command Code Generation.");
                CmdGenerator.execute();
                this.getLog().info((CharSequence)"Finished Command Code Generation.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateResources(Set<Artifact> artifacts) throws IOException, MojoExecutionException {
        if (this.generateResources.booleanValue()) {
            File resourceFolder;
            boolean resourcesExistsInCurrentProject;
            this.requireModelPackage();
            if (this.resourcePackage == null) {
                Configuration.resourcePackage = "org.tomitribe.resources";
            }
            if (!(resourcesExistsInCurrentProject = (resourceFolder = new File(Configuration.getResourcePath())).exists())) {
                resourceFolder.mkdirs();
            }
            this.getLog().info((CharSequence)"Started Resource Code Generation.");
            ResourcesGenerator.execute();
            this.getLog().info((CharSequence)"Finished Resource Code Generation.");
            Configuration.resourceSources = Configuration.generatedSources;
        } else if (this.resourcePackage != null) {
            List resourceDependencies;
            List compileSourceRoots = this.project.getCompileSourceRoots();
            if (compileSourceRoots != null) {
                for (String source : compileSourceRoots) {
                    File folder = new File(source, Utils.transformPackageToPath((String)Configuration.resourcePackage));
                    if (!folder.exists()) continue;
                    Configuration.resourceSources = source;
                    return;
                }
            }
            if ((resourceDependencies = artifacts.stream().filter(a -> this.hasResources(a.getFile())).collect(Collectors.toList())).size() == 0) {
                throw new MojoExecutionException("Resources were not found. Add the correct 'resourcePackage' for this project or add a jar with the .java files for the resources.");
            }
            resourceDependencies.stream().forEach(m -> this.extractJavaFiles(m.getFile()));
            Configuration.resourceSources = Configuration.tempSource;
        }
        Configuration.clientSources = Configuration.resourceSources;
    }

    private void generateModel(Set<Artifact> artifacts) throws IOException, MojoExecutionException {
        if (this.generateModel.booleanValue()) {
            this.requireModelPackage();
            File modelFolder = new File(Configuration.getModelPath());
            boolean existsInCurrentProject = modelFolder.exists();
            if (!existsInCurrentProject) {
                modelFolder.mkdirs();
            }
            this.getLog().info((CharSequence)"Started Model Code Generation.");
            ModelGenerator.execute();
            this.getLog().info((CharSequence)"Finished Model Code Generation.");
        } else if (this.modelPackage != null) {
            List modelDependencies;
            List compileSourceRoots = this.project.getCompileSourceRoots();
            if (compileSourceRoots != null) {
                for (String source : compileSourceRoots) {
                    File folder = new File(source, Utils.transformPackageToPath((String)Configuration.modelPackage));
                    if (!folder.exists()) continue;
                    Configuration.modelSources = source;
                    return;
                }
            }
            if ((modelDependencies = artifacts.stream().filter(a -> this.hasModel(a.getFile())).collect(Collectors.toList())).size() == 0) {
                throw new MojoExecutionException("Model was not found. Add the correct 'modelPackage' for this project or add a jar with the .java files for the model.");
            }
            modelDependencies.stream().forEach(m -> this.extractJavaFiles(m.getFile()));
            Configuration.modelSources = Configuration.tempSource;
        }
    }

    private boolean hasModel(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().equals(Utils.transformPackageToPath((String)Configuration.modelPackage) + File.separator)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean hasResources(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().equals(Utils.transformPackageToPath((String)Configuration.resourcePackage) + File.separator)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean hasClient(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String pkg = Utils.transformPackageToPath((String)Configuration.resourcePackage) + File.separator + "client";
                if (!zipEntry.getName().equals(pkg) && !zipEntry.getName().equals(pkg + File.separator)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void extractJavaFiles(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".java")) continue;
                InputStream is = jar.getInputStream(zipEntry);
                File generatedSources = new File(Configuration.tempSource);
                File output = new File(generatedSources, File.separator + zipEntry.getName());
                if (!output.getParentFile().exists()) {
                    output.getParentFile().mkdirs();
                }
                output.createNewFile();
                FileOutputStream fos = new FileOutputStream(output);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
            jar.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void requireResourcePackage() throws MojoExecutionException {
        if (this.resourcePackage == null) {
            throw new MojoExecutionException("The 'resourcePackage' configuration was not found.");
        }
    }

    private void requireModelPackage() throws MojoExecutionException {
        if (this.modelPackage == null) {
            throw new MojoExecutionException("The 'modelPackage' configuration was not found.");
        }
    }
}

