/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="executable", requiresProject=true, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ReallyExecutableJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="", property="really-executable-jar.flags")
    private String flags = "";
    @Parameter(property="really-executable-jar.cmdFileName")
    private String cmdFileName = null;
    @Parameter(property="really-executable-jar.classifier")
    private String classifier;
    @Parameter(property="really-executable-jar.allowOtherTypes")
    private String allowOtherTypes;
    @Parameter(defaultValue="false", property="really-executable-jar.attachProgramFile")
    private boolean attachProgramFile = false;
    @Parameter(defaultValue="sh", property="really-executable-jar.programFileType")
    private String programFileType = "sh";
    @Parameter(property="really-executable-jar.scriptFile")
    private String scriptFile = null;
    @Parameter(property="really-executable-jar.shadedJar")
    private String shadedJar = null;

    public void execute() throws MojoExecutionException {
        try {
            ArrayList<File> files = new ArrayList<File>();
            if (!StringUtils.isEmpty((CharSequence)this.shadedJar)) {
                File f = new File(this.project.getBasedir() + "/target", this.shadedJar);
                if (f.exists()) {
                    files.add(f);
                }
            } else {
                if (this.shouldProcess(this.project.getArtifact())) {
                    files.add(this.project.getArtifact().getFile());
                }
                for (Artifact item : this.project.getAttachedArtifacts()) {
                    if (!this.shouldProcess(item)) continue;
                    files.add(item.getFile());
                }
            }
            if (files.isEmpty()) {
                throw new MojoExecutionException("Could not find any jars to make executable");
            }
            if (this.cmdFileName != null && !this.cmdFileName.matches("\\s+")) {
                for (File file : files) {
                    File dir = file.getParentFile();
                    File exec = new File(dir, this.cmdFileName);
                    FileUtils.copyFile((File)file, (File)exec);
                    this.makeExecutable(exec);
                    if (!this.attachProgramFile) continue;
                    this.projectHelper.attachArtifact(this.project, this.programFileType, exec);
                }
            } else {
                for (File file : files) {
                    this.makeExecutable(file);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean shouldProcess(Artifact artifact) {
        this.getLog().debug((CharSequence)("Considering " + artifact));
        if (artifact == null) {
            return false;
        }
        if (!Boolean.valueOf(this.allowOtherTypes).booleanValue() && !artifact.getType().equals("jar")) {
            return false;
        }
        return this.classifier == null || this.classifier.equals(artifact.getClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeExecutable(File file) throws IOException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Making " + file.getAbsolutePath() + " executable"));
        Path original = Paths.get(file.getAbsolutePath() + ".rx-orig", new String[0]);
        Files.move(file.toPath(), original, new CopyOption[0]);
        try (FileOutputStream out = new FileOutputStream(file);
             InputStream in = Files.newInputStream(original, new OpenOption[0]);){
            if (this.scriptFile == null) {
                out.write(("#!/bin/sh\n\nexec java " + this.flags + " -jar \"$0\" \"$@\"\n\n").getBytes("ASCII"));
            } else if (Files.exists(Paths.get(this.scriptFile, new String[0]), new LinkOption[0])) {
                this.getLog().debug((CharSequence)String.format("Loading file[%s] from filesystem", this.scriptFile));
                byte[] script = Files.readAllBytes(Paths.get(this.scriptFile, new String[0]));
                out.write(script);
                out.write(new byte[]{10, 10});
            } else {
                this.getLog().debug((CharSequence)String.format("Loading file[%s] from jar[%s]", this.scriptFile, original));
                try (URLClassLoader loader = new URLClassLoader(new URL[]{original.toUri().toURL()}, null);
                     InputStream scriptIn = loader.getResourceAsStream(this.scriptFile);){
                    out.write(IOUtil.toString((InputStream)scriptIn).getBytes("ASCII"));
                    out.write("\n\n".getBytes("ASCII"));
                }
            }
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            Files.deleteIfExists(original);
        }
        file.setExecutable(true, false);
        this.getLog().info((CharSequence)String.format("Successfully made JAR [%s] executable", file.getAbsolutePath()));
    }
}

