/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.model;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.tomitribe.inget.common.Configuration;
import org.tomitribe.inget.common.ImportManager;
import org.tomitribe.inget.common.Utils;

public class ModelClassGenerator {
    private ModelClassGenerator() {
    }

    static CompilationUnit createClass(CompilationUnit rootClassUnit, ClassOrInterfaceDeclaration rootClass, String rootClassName, String operation, String classPrefix) throws IOException {
        CompilationUnit newClassCompilationUnit = new CompilationUnit(((PackageDeclaration)rootClassUnit.getPackageDeclaration().get()).getName().toString());
        String className = classPrefix + rootClassName;
        newClassCompilationUnit.addClass(className, new Modifier[]{Modifier.PUBLIC});
        ClassOrInterfaceDeclaration newClass = (ClassOrInterfaceDeclaration)newClassCompilationUnit.getClassByName(className).get();
        newClass.addMarkerAnnotation("Value");
        newClassCompilationUnit.addImport(ImportManager.getImport((String)"Value"));
        String builderClassName = classPrefix.length() != 0 ? classPrefix : "Read";
        NormalAnnotationExpr builderAnnotation = new NormalAnnotationExpr();
        builderAnnotation.setName("Builder");
        builderAnnotation.addPair("builderClassName", "\"" + builderClassName + "\"");
        builderAnnotation.addPair("toBuilder", "true");
        newClass.addAnnotation((AnnotationExpr)builderAnnotation);
        newClassCompilationUnit.addImport(ImportManager.getImport((String)"Builder"));
        Utils.addLicense((CompilationUnit)rootClassUnit, (CompilationUnit)newClassCompilationUnit);
        Utils.addGeneratedAnnotation((CompilationUnit)newClassCompilationUnit, (ClassOrInterfaceDeclaration)newClass, null, ModelClassGenerator.class);
        Optional schema = rootClass.getAnnotationByName("Schema");
        if (schema.isPresent()) {
            newClass.addAnnotation((AnnotationExpr)schema.get());
        }
        ModelClassGenerator.handleExtendedClasses(rootClassUnit, rootClass, operation, newClass, classPrefix);
        rootClass.getFields().stream().forEach(f -> ModelClassGenerator.handleField(operation, rootClassUnit, newClass, f, classPrefix));
        Utils.addImports((CompilationUnit)rootClassUnit, (CompilationUnit)newClassCompilationUnit);
        return newClassCompilationUnit;
    }

    private static void handleExtendedClasses(CompilationUnit rootClassUnit, ClassOrInterfaceDeclaration rootClass, String operation, ClassOrInterfaceDeclaration newClass, String prefix) throws IOException {
        NodeList extendedTypes = rootClass.getExtendedTypes();
        while (extendedTypes.size() > 0) {
            for (ClassOrInterfaceType et : extendedTypes) {
                ClassOrInterfaceDeclaration extendedClass = Utils.getExtendedClass((CompilationUnit)rootClassUnit, (String)et.getNameAsString());
                extendedClass.getFields().forEach(f -> ModelClassGenerator.handleField(operation, rootClassUnit, newClass, f, prefix));
                Utils.addImports((CompilationUnit)((CompilationUnit)extendedClass.findCompilationUnit().get()), (CompilationUnit)((CompilationUnit)newClass.findCompilationUnit().get()));
                extendedTypes = extendedClass.getExtendedTypes();
            }
        }
    }

    private static void handleField(String operation, CompilationUnit unit, ClassOrInterfaceDeclaration newClass, FieldDeclaration f, String prefix) {
        FieldDeclaration newField = f.clone();
        if (!newField.getAnnotationByName("Model").isPresent() || !Utils.hasOperations((FieldDeclaration)newField) || Utils.isOperationPresent((FieldDeclaration)newField, (String)operation)) {
            ModelClassGenerator.handleExpandableField(newField, prefix, unit);
            newClass.addMember((BodyDeclaration)newField);
        }
        if (newField.getAnnotationByName("Model").isPresent()) {
            AnnotationExpr modelAnnotation = (AnnotationExpr)newField.getAnnotationByName("Model").get();
            newField.remove((Node)modelAnnotation);
        }
    }

    private static void handleExpandableField(FieldDeclaration field, String prefix, CompilationUnit unit) {
        VariableDeclarator variable = (VariableDeclarator)field.getVariables().stream().findFirst().get();
        boolean isExpandable = variable.getTypeAsString().contains(Configuration.modelSuffix);
        if (isExpandable) {
            String entityAfter;
            String end = variable.getTypeAsString();
            String entityBefore = variable.getTypeAsString();
            if (variable.getTypeAsString().contains("<")) {
                entityBefore = end.substring(end.indexOf("<") + 1, end.indexOf(">"));
                entityAfter = prefix + entityBefore.replace(Configuration.modelSuffix, "");
                end = end.replace(entityBefore, entityAfter);
            } else {
                entityAfter = end = prefix + end.replace(Configuration.modelSuffix, "");
            }
            variable.setType(end);
            String finalEntityBefore = entityBefore;
            Optional<ImportDeclaration> imp = unit.getImports().stream().filter(i -> i.getNameAsString().contains("." + finalEntityBefore)).findFirst();
            if (imp.isPresent()) {
                String importDeclaration = imp.get().getNameAsString();
                importDeclaration = importDeclaration.replace(entityBefore, entityAfter);
                unit.addImport(importDeclaration);
            }
        }
    }

    static CompilationUnit createListClass(CompilationUnit rootClassUnit, ClassOrInterfaceDeclaration rootClass, String rootClassName, CompilationUnit filterClassUnit, CompilationUnit summaryClassUnit, String listClassName) throws IOException {
        if (!rootClass.getAnnotationByName("Resource").isPresent()) {
            return null;
        }
        String summaryClassValue = rootClassName;
        if (summaryClassUnit != null) {
            summaryClassValue = Utils.getClazz((CompilationUnit)summaryClassUnit).getNameAsString();
        }
        String filterName = "";
        boolean importDefault = false;
        if (filterClassUnit == null) {
            filterName = "DefaultFilter";
            importDefault = true;
        } else {
            filterName = Utils.getClazz((CompilationUnit)filterClassUnit).getNameAsString();
        }
        String resultTextClass = "import io.swagger.v3.oas.annotations.media.Schema;\nimport lombok.Builder;\nimport lombok.EqualsAndHashCode;\nimport lombok.Value;\n\nimport javax.annotation.Generated;\nimport java.util.Collection;\n\n@Value\n@Builder\n@EqualsAndHashCode\n@Generated(value = \"org.tomitribe.model.ModelGenerator\")\n@Schema(description = \"The list of %ITEMS_NAME available for a given search request with associated metadata.\")\npublic class %ENTITYResult {\n\n    @Schema(description = \"The list of items for the given page. The list may be a partial list when pagination is used (default)\", required = true)\n    private final Collection<%ENTITY> items;\n\n    @Schema(description = \"Contains the elements that can be used for filtering: labels, by default.\", required = true)\n    private final %FILTER filters;\n\n    @Schema(description = \"The total number of items for the search request. It may be higher than the number of items returned because of the pagination.\", required = true)\n    private final Long total;\n\n}".replaceAll("%ENTITY", summaryClassValue).replaceAll("%FILTER", filterName).replaceAll("%ITEMS_NAME", listClassName.toLowerCase());
        CompilationUnit newClassCompilationUnit = JavaParser.parse((String)resultTextClass);
        newClassCompilationUnit.setPackageDeclaration(((PackageDeclaration)rootClassUnit.getPackageDeclaration().get()).getNameAsString());
        Utils.addLicense((CompilationUnit)rootClassUnit, (CompilationUnit)newClassCompilationUnit);
        if (importDefault) {
            newClassCompilationUnit.addImport(Configuration.modelPackage + ".base.filter.DefaultFilter");
        }
        return newClassCompilationUnit;
    }

    static CompilationUnit createFilterClass(ClassOrInterfaceDeclaration rootClass, CompilationUnit rootClassUnit, String filterClassName) {
        List filterFields = rootClass.getFields().stream().filter(f -> {
            Optional modelAnnotationOptional = f.getAnnotationByName("Model");
            if (!modelAnnotationOptional.isPresent()) {
                return false;
            }
            NormalAnnotationExpr model = ((AnnotationExpr)modelAnnotationOptional.get()).asNormalAnnotationExpr();
            Map pairs = Utils.pairs((NormalAnnotationExpr)model);
            MemberValuePair filterValuePair = (MemberValuePair)pairs.get("filter");
            return filterValuePair != null;
        }).collect(Collectors.toList());
        if (filterFields.size() == 0) {
            return null;
        }
        CompilationUnit filterClassCompilationUnit = new CompilationUnit(((PackageDeclaration)rootClassUnit.getPackageDeclaration().get()).getName().toString());
        filterClassCompilationUnit.addClass(filterClassName, new Modifier[]{Modifier.PUBLIC});
        ClassOrInterfaceDeclaration filterClass = (ClassOrInterfaceDeclaration)filterClassCompilationUnit.getClassByName(filterClassName).get();
        filterClass.addExtendedType("DefaultFilter");
        filterClassCompilationUnit.addImport(Configuration.modelPackage + ".base.filter.DefaultFilter");
        filterClass.addMarkerAnnotation("Builder");
        filterClassCompilationUnit.addImport(ImportManager.getImport((String)"Builder"));
        filterClass.addMarkerAnnotation("ToString");
        filterClassCompilationUnit.addImport(ImportManager.getImport((String)"ToString"));
        Utils.addLicense((CompilationUnit)rootClassUnit, (CompilationUnit)filterClassCompilationUnit);
        filterFields.stream().forEach(f -> {
            NormalAnnotationExpr model = ((AnnotationExpr)f.getAnnotationByName("Model").get()).asNormalAnnotationExpr();
            Map modelPairs = Utils.pairs((NormalAnnotationExpr)model);
            NormalAnnotationExpr filter = ((MemberValuePair)modelPairs.get("filter")).getValue().asNormalAnnotationExpr();
            Map pairs = Utils.pairs((NormalAnnotationExpr)filter);
            MemberValuePair nameValuePair = (MemberValuePair)pairs.get("name");
            String name = nameValuePair.getValue().asStringLiteralExpr().getValue();
            if (name.equals("")) {
                name = ((VariableDeclarator)f.getVariables().stream().findFirst().get()).getNameAsString();
            }
            MemberValuePair multipleValuePair = (MemberValuePair)pairs.get("multiple");
            TypeParameter type = new TypeParameter("String");
            boolean multiple = false;
            if (multipleValuePair != null && (multiple = multipleValuePair.getValue().asBooleanLiteralExpr().getValue())) {
                type = new TypeParameter("Collection<String>");
                filterClassCompilationUnit.addImport(ImportManager.getImport((String)"Collection"));
            }
            FieldDeclaration newField = filterClass.addField((Type)type, name, new Modifier[]{Modifier.PUBLIC});
            NormalAnnotationExpr schema = new NormalAnnotationExpr();
            schema.setName("Schema");
            if (multiple) {
                schema.addPair("description", "\"The set of unique " + name + " in all returned items.\"");
            } else {
                schema.addPair("description", "\"The " + name + " in all returned items.\"");
            }
            newField.addAnnotation((AnnotationExpr)schema);
            filterClassCompilationUnit.addImport(ImportManager.getImport((String)"Schema"));
        });
        return filterClassCompilationUnit;
    }

    static CompilationUnit createBulkClass(CompilationUnit rootClassUnit, ClassOrInterfaceDeclaration rootClass, String rootClassName, String bulkClassName) throws IOException {
        if (!rootClass.getAnnotationByName("Resource").isPresent()) {
            return null;
        }
        CompilationUnit newClassCompilationUnit = new CompilationUnit(((PackageDeclaration)rootClassUnit.getPackageDeclaration().get()).getName().toString());
        newClassCompilationUnit.addClass(bulkClassName, new Modifier[]{Modifier.PUBLIC});
        ClassOrInterfaceDeclaration newClass = (ClassOrInterfaceDeclaration)newClassCompilationUnit.getClassByName(bulkClassName).get();
        newClass.addMarkerAnnotation("Value");
        newClassCompilationUnit.addImport(ImportManager.getImport((String)"Value"));
        newClass.addMarkerAnnotation("EqualsAndHashCode");
        newClassCompilationUnit.addImport(ImportManager.getImport((String)"EqualsAndHashCode"));
        Utils.addLicense((CompilationUnit)rootClassUnit, (CompilationUnit)newClassCompilationUnit);
        Utils.addGeneratedAnnotation((CompilationUnit)newClassCompilationUnit, (ClassOrInterfaceDeclaration)newClass, null, ModelClassGenerator.class);
        NormalAnnotationExpr schema = new NormalAnnotationExpr();
        schema.setName("Schema");
        schema.addPair("description", "\"The result of the bulk operation.\"");
        newClass.addAnnotation((AnnotationExpr)schema);
        newClassCompilationUnit.addImport(ImportManager.getImport((String)"Schema"));
        String paramName = Utils.toPlural((String)rootClassName.toLowerCase());
        NormalAnnotationExpr fieldSchema = new NormalAnnotationExpr();
        fieldSchema.setName("Schema");
        fieldSchema.addPair("description", "\"The " + paramName + " that failed in the bulk operation.\"");
        FieldDeclaration fieldDeclaration = newClass.addField((Type)new TypeParameter("List<Failure>"), paramName, new Modifier[]{Modifier.PRIVATE});
        fieldDeclaration.addAnnotation((AnnotationExpr)fieldSchema);
        newClassCompilationUnit.addImport(Configuration.modelPackage + ".base.bulk.Failure");
        newClassCompilationUnit.addImport(ImportManager.getImport((String)"List"));
        return newClassCompilationUnit;
    }

    public static CompilationUnit createSummaryClass(ClassOrInterfaceDeclaration rootClass, CompilationUnit rootClassUnit, String summaryClassName) {
        List summaryFields = rootClass.getFields().stream().filter(f -> {
            Optional modelAnnotationOptional = f.getAnnotationByName("Model");
            if (!modelAnnotationOptional.isPresent()) {
                return false;
            }
            NormalAnnotationExpr model = ((AnnotationExpr)modelAnnotationOptional.get()).asNormalAnnotationExpr();
            Map pairs = Utils.pairs((NormalAnnotationExpr)model);
            MemberValuePair filterValuePair = (MemberValuePair)pairs.get("summary");
            if (filterValuePair != null) {
                return filterValuePair.getValue().asBooleanLiteralExpr().getValue();
            }
            return false;
        }).collect(Collectors.toList());
        if (summaryFields.size() == 0) {
            return null;
        }
        CompilationUnit summaryUnit = new CompilationUnit(((PackageDeclaration)rootClassUnit.getPackageDeclaration().get()).getName().toString());
        summaryUnit.addClass(summaryClassName, new Modifier[]{Modifier.PUBLIC});
        ClassOrInterfaceDeclaration summaryClass = (ClassOrInterfaceDeclaration)summaryUnit.getClassByName(summaryClassName).get();
        summaryClass.addMarkerAnnotation("Data");
        summaryUnit.addImport(ImportManager.getImport((String)"Data"));
        summaryClass.addMarkerAnnotation("EqualsAndHashCode");
        summaryUnit.addImport(ImportManager.getImport((String)"EqualsAndHashCode"));
        summaryClass.addMarkerAnnotation("AllArgsConstructor");
        summaryUnit.addImport(ImportManager.getImport((String)"AllArgsConstructor"));
        Utils.addLicense((CompilationUnit)rootClassUnit, (CompilationUnit)summaryUnit);
        String rootClassName = Utils.getRootName((ClassOrInterfaceDeclaration)Utils.getClazz((CompilationUnit)rootClassUnit));
        String schemaDescription = "Summary of the search for " + Utils.toPlural((String)rootClassName);
        NormalAnnotationExpr classSchema = new NormalAnnotationExpr();
        classSchema.setName("Schema");
        classSchema.addPair("description", "\"" + schemaDescription + "\"");
        summaryClass.addAnnotation((AnnotationExpr)classSchema);
        summaryFields.stream().forEach(f -> {
            VariableDeclarator fieldVariable = (VariableDeclarator)f.getVariables().stream().findFirst().get();
            FieldDeclaration newField = summaryClass.addField(fieldVariable.getType(), fieldVariable.getNameAsString(), new Modifier[]{Modifier.PRIVATE});
            Optional fieldSchema = f.getAnnotationByName("Schema");
            if (fieldSchema.isPresent()) {
                newField.addAnnotation((AnnotationExpr)fieldSchema.get());
                summaryUnit.addImport(ImportManager.getImport((String)"Schema"));
            }
        });
        return summaryUnit;
    }

    public static void createBaseClasses() throws IOException {
        String outputBasePackage = Configuration.modelPackage + ".base";
        ModelClassGenerator.createFailureClass(outputBasePackage);
        ModelClassGenerator.createDefaultFilterClass(outputBasePackage);
    }

    private static void createFailureClass(String outputBasePackage) throws IOException {
        String pkg = outputBasePackage + ".bulk";
        CompilationUnit content = JavaParser.parse((String)"import io.swagger.v3.oas.annotations.media.Schema;\nimport lombok.AllArgsConstructor;\nimport lombok.Value;\n\n@Value\n@AllArgsConstructor\n@Schema(description = \"Failure details\")\npublic class Failure {\n\n    @Schema(description = \"name of the entity that failed to be updated.\", required = true)\n    private final String name;\n\n    @Schema(description = \"message for the failure.\", required = true)\n    private final String message;\n\n    @Schema(description = \"code for the failure.\", required = true)\n    private final String code;\n}");
        content.setPackageDeclaration(pkg);
        Utils.addGeneratedAnnotation((CompilationUnit)content, (ClassOrInterfaceDeclaration)Utils.getClazz((CompilationUnit)content), null, ModelClassGenerator.class);
        Utils.save((String)"Failure.java", (String)pkg, (String)content.toString());
    }

    private static void createDefaultFilterClass(String outputBasePackage) throws IOException {
        String pkg = outputBasePackage + ".filter";
        CompilationUnit content = JavaParser.parse((String)"import io.swagger.v3.oas.annotations.media.Schema;\n\n@Schema(description = \"A generic filter, part of the page result used for any search request. \" +\n        \"Sub-classes contain the elements that can be used for filtering.\")\npublic class DefaultFilter {\n}");
        content.setPackageDeclaration(pkg);
        Utils.addGeneratedAnnotation((CompilationUnit)content, (ClassOrInterfaceDeclaration)Utils.getClazz((CompilationUnit)content), null, ModelClassGenerator.class);
        Utils.save((String)"DefaultFilter.java", (String)pkg, (String)content.toString());
    }
}

