/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.model;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.tomitribe.inget.common.Reformat;
import org.tomitribe.inget.common.RemoveDuplicateImports;
import org.tomitribe.inget.common.Utils;
import org.tomitribe.inget.model.ModelClassGenerator;
import org.tomitribe.inget.model.ModelMethodGenerator;
import org.tomitribe.util.IO;

public class ModelGenerator {
    static final String CREATE_PREFIX = "Create";
    static final String UPDATE_PREFIX = "Update";
    static final String READ_PREFIX = "";

    private ModelGenerator() {
    }

    public static void execute() throws IOException {
        List modelFiles = Utils.getModel();
        ModelClassGenerator.createBaseClasses();
        for (File rootClassFile : modelFiles) {
            String bulkClassName;
            CompilationUnit bulkUnit;
            String listClassName;
            CompilationUnit listUnit;
            String rootClassSource = IO.slurp((File)rootClassFile);
            CompilationUnit rootClassUnit = JavaParser.parse((String)rootClassSource);
            ClassOrInterfaceDeclaration rootClass = Utils.getClazz((CompilationUnit)rootClassUnit);
            if (rootClass == null) continue;
            String rootClassName = Utils.getRootName((ClassOrInterfaceDeclaration)Utils.getClazz((CompilationUnit)rootClassUnit));
            List classOperations = Utils.getClassOperations((ClassOrInterfaceDeclaration)rootClass);
            CompilationUnit createUnit = null;
            CompilationUnit updateUnit = null;
            String summaryClassName = rootClassName + "Summary";
            CompilationUnit summaryUnit = ModelClassGenerator.createSummaryClass(rootClass, rootClassUnit, summaryClassName);
            ModelGenerator.save(summaryClassName, rootClassUnit, summaryUnit);
            String filterClassName = rootClassName + "Filter";
            CompilationUnit filterUnit = ModelClassGenerator.createFilterClass(rootClass, rootClassUnit, filterClassName);
            ModelGenerator.save(filterClassName, rootClassUnit, filterUnit);
            if ((classOperations == null || classOperations.contains("Model.Operation.READ_ALL")) && (listUnit = ModelClassGenerator.createListClass(rootClassUnit, rootClass, rootClassName, filterUnit, summaryUnit, listClassName = Utils.toPlural((String)rootClassName))) != null) {
                ModelGenerator.save(rootClassName + "Result", rootClassUnit, listUnit);
            }
            if ((classOperations == null || classOperations.contains("Model.Operation.BULK_CREATE") || classOperations.contains("Model.Operation.BULK_UPDATE") || classOperations.contains("Model.Operation.BULK_DELETE")) && (bulkUnit = ModelClassGenerator.createBulkClass(rootClassUnit, rootClass, rootClassName, bulkClassName = "Bulk" + rootClassName + "Result")) != null) {
                ModelGenerator.save(bulkClassName, rootClassUnit, bulkUnit);
            }
            if (classOperations == null || classOperations.contains("Model.Operation.CREATE")) {
                createUnit = ModelClassGenerator.createClass(rootClassUnit, rootClass, rootClassName, "Model.Operation.CREATE", CREATE_PREFIX);
                ModelGenerator.save(CREATE_PREFIX + rootClassName, rootClassUnit, createUnit);
            }
            if (classOperations == null || classOperations.contains("Model.Operation.UPDATE")) {
                updateUnit = ModelClassGenerator.createClass(rootClassUnit, rootClass, rootClassName, "Model.Operation.UPDATE", UPDATE_PREFIX);
                ModelGenerator.save(UPDATE_PREFIX + rootClassName, rootClassUnit, updateUnit);
            }
            CompilationUnit readUnit = ModelClassGenerator.createClass(rootClassUnit, rootClass, rootClassName, "Model.Operation.READ", READ_PREFIX);
            readUnit = ModelMethodGenerator.createMethods(rootClassName, rootClassUnit, createUnit, updateUnit, readUnit, classOperations);
            ModelGenerator.save(READ_PREFIX + rootClassName, rootClassUnit, readUnit);
        }
    }

    public static void save(String className, CompilationUnit rootClassUnit, CompilationUnit classToBeSaved) throws IOException {
        if (classToBeSaved == null) {
            return;
        }
        String modified = Stream.of(classToBeSaved.toString()).map(RemoveDuplicateImports::apply).map(Reformat::apply).map(RemoveUnusedImports::removeUnusedImports).findFirst().get();
        Utils.save((String)(className + ".java"), (String)((PackageDeclaration)rootClassUnit.getPackageDeclaration().get()).getName().toString(), (String)modified);
    }
}

