/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.model;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import java.util.List;
import java.util.Optional;
import org.tomitribe.inget.common.Utils;

public class ModelMethodGenerator {
    private ModelMethodGenerator() {
    }

    static CompilationUnit createMethods(String rootClassName, CompilationUnit rootUnit, CompilationUnit createUnit, CompilationUnit updateUnit, CompilationUnit readUnit, List<String> classOperations) {
        ClassOrInterfaceDeclaration readClass = (ClassOrInterfaceDeclaration)readUnit.getClassByName(rootClassName).get();
        if (createUnit != null) {
            ModelMethodGenerator.addConversionMethod(createUnit, readClass, "Create");
            ModelMethodGenerator.addBuilderMethods(createUnit, readClass, "Create");
        }
        if (updateUnit != null) {
            ModelMethodGenerator.addConversionMethod(updateUnit, readClass, "Update");
            ModelMethodGenerator.addBuilderMethods(updateUnit, readClass, "Update");
        }
        if (classOperations == null || classOperations.contains("Model.Operation.DELETE")) {
            ModelMethodGenerator.addDeleteMethod(rootUnit, readClass);
        }
        return readUnit;
    }

    static void addDeleteMethod(CompilationUnit rootUnit, ClassOrInterfaceDeclaration readClass) {
        ClassOrInterfaceDeclaration rootClass = Utils.getClazz((CompilationUnit)rootUnit);
        List fields = rootClass.getFields();
        StringBuilder methodBuilder = new StringBuilder();
        methodBuilder.append("public String toDelete() {");
        methodBuilder.append("return this.%field;");
        methodBuilder.append("}");
        Optional<FieldDeclaration> id = fields.stream().filter(f -> Utils.isId((FieldDeclaration)f)).findFirst();
        if (id.isPresent()) {
            String result = methodBuilder.toString().replaceAll("%field", ((VariableDeclarator)id.get().getVariables().stream().findFirst().get()).getNameAsString());
            MethodDeclaration methodDeclaration = JavaParser.parseBodyDeclaration((String)result).asMethodDeclaration();
            readClass.addMember((BodyDeclaration)methodDeclaration);
        }
    }

    static void addBuilderMethods(CompilationUnit classToBeBuiltUnit, ClassOrInterfaceDeclaration readClass, String prefix) {
        ClassOrInterfaceDeclaration classToBeBuilt = Utils.getClazz((CompilationUnit)classToBeBuiltUnit);
        StringBuilder methodBuilder = new StringBuilder();
        methodBuilder.append("public static %classname.%prefix %methodname(){");
        methodBuilder.append("return %classname.builder();");
        methodBuilder.append("}");
        String result = methodBuilder.toString().replaceAll("%classname", classToBeBuilt.getNameAsString()).replaceAll("%methodname", prefix.toLowerCase()).replaceAll("%prefix", prefix);
        MethodDeclaration methodDeclaration = JavaParser.parseBodyDeclaration((String)result).asMethodDeclaration();
        readClass.addMember((BodyDeclaration)methodDeclaration);
    }

    static void addConversionMethod(CompilationUnit classToBeConvertedUnit, ClassOrInterfaceDeclaration readClass, String prefix) {
        StringBuilder methodBuilder = new StringBuilder();
        methodBuilder.append("public %classname.%prefix to%prefix() {");
        methodBuilder.append("return %classname.builder()");
        ClassOrInterfaceDeclaration classToBeConverted = Utils.getClazz((CompilationUnit)classToBeConvertedUnit);
        classToBeConverted.getFields().stream().forEach(f -> {
            VariableDeclarator fieldClassToBeConverted = (VariableDeclarator)f.getVariables().stream().findFirst().get();
            String propertyName = fieldClassToBeConverted.getNameAsString();
            String typeName = fieldClassToBeConverted.getTypeAsString();
            Optional readField = readClass.getFieldByName(propertyName);
            if (readField.isPresent() && ((FieldDeclaration)readField.get()).getCommonType().asString().equals(typeName)) {
                methodBuilder.append(".%property(this.%property)".replaceAll("%property", propertyName));
            }
        });
        methodBuilder.append(";");
        methodBuilder.append("\n}");
        String result = methodBuilder.toString().replaceAll("%classname", classToBeConverted.getNameAsString()).replaceAll("%prefix", prefix);
        MethodDeclaration methodDeclaration = JavaParser.parseBodyDeclaration((String)result).asMethodDeclaration();
        readClass.addMember((BodyDeclaration)methodDeclaration);
    }
}

