/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class CleanOnExit {
    private final List<File> files = new ArrayList<File>();

    public CleanOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::clean));
    }

    public File clean(File file) {
        this.files.add(file);
        return file;
    }

    private void clean() {
        this.files.stream().forEach(CleanOnExit::delete);
    }

    public static void delete(File file) {
        try {
            Files.walkFileTree(file.toPath(), new RecursiveDelete());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class RecursiveDelete
    implements FileVisitor<Path> {
        private RecursiveDelete() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

