/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.tomitribe.inget.api.Model;
import org.tomitribe.inget.test.CleanOnExit;
import org.tomitribe.inget.test.Resources;
import org.tomitribe.inget.test.Urls;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;
import org.tomitribe.util.JarLocation;
import org.tomitribe.util.Strings;

public class Generation {
    private Generation() {
    }

    public static void saveResults(String name, String location, Map<String, File> results) throws IOException {
        URL resource = Resources.class.getClassLoader().getResource("root.txt");
        Assert.assertNotNull((Object)resource);
        File file = Urls.toFile(resource);
        File module = Generation.parentOf("target", file);
        File dir = Files.file((File)module, (String[])new String[]{"src", "test", "resources", name, location});
        Files.mkdirs((File)dir);
        CleanOnExit.delete(dir);
        for (Map.Entry<String, File> entry : results.entrySet()) {
            File dest = new File(dir, entry.getKey());
            Files.mkparent((File)dest);
            IO.copy((File)entry.getValue(), (File)dest);
        }
    }

    public static void saveContent(String name, String location, Map<String, String> results) throws IOException {
        URL resource = Resources.class.getClassLoader().getResource("root.txt");
        Assert.assertNotNull((Object)resource);
        File file = Urls.toFile(resource);
        File module = Generation.parentOf("target", file);
        File dir = Files.file((File)module, (String[])new String[]{"src", "test", "resources", name, location});
        Files.mkdirs((File)dir);
        Generation.saveContent(results, dir);
    }

    public static void saveContent(Map<String, String> results, File dir) throws IOException {
        for (Map.Entry<String, String> entry : results.entrySet()) {
            File dest = new File(dir, entry.getKey());
            Files.mkparent((File)dest);
            IO.copy((InputStream)IO.read((String)entry.getValue()), (File)dest);
        }
    }

    private static File parentOf(String dir, File file) {
        if (file.getName().equals(dir)) {
            return file.getParentFile();
        }
        return Generation.parentOf(dir, file.getParentFile());
    }

    public static void main(String[] args) throws IOException {
        File thisClazz = JarLocation.jarLocation(Generation.class);
        File project = Generation.parentOf("inget-testing", thisClazz);
        File srcTest = Files.file((File)project, (String[])new String[]{"inget-model", "src", "test"});
        for (Model.Operation operation : Model.Operation.values()) {
            String read = Strings.camelCase((String)operation.name().toLowerCase(), (String)"_");
            String testName = "Operation" + read + "Test";
            HashMap<String, String> tests = new HashMap<String, String>();
            tests.put("java/org/tomitribe/model/" + testName + ".java", "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n *  Unless required by applicable law or agreed to in writing, software\n *  distributed under the License is distributed on an \"AS IS\" BASIS,\n *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n *  See the License for the specific language governing permissions and\n *  limitations under the License.\n */\npackage org.tomitribe.model;\n\nimport org.junit.Test;\nimport org.tomitribe.inget.common.Configuration;\nimport org.tomitribe.inget.test.Resources;\nimport org.tomitribe.inget.test.Generation;\n\nimport static org.tomitribe.inget.test.Scenarios.assertFiles;\n\npublic class " + testName + " {\n\n    @Test\n    public void testOnClass() throws Exception {\n        final Resources resources = Resources.name(\"" + testName + "/testOnClass\");\n\n        Configuration.clean();\n        Configuration.modelSources = resources.input().getAbsolutePath();\n        Configuration.resourceSources = resources.input().getAbsolutePath();\n        Configuration.generatedSources = resources.actual().getAbsolutePath();\n        Configuration.modelPackage = \"io.superbiz.video.model\";\n        Configuration.modelSuffix = \"Model\";\n        Configuration.tempSource = resources.tempSource().getAbsolutePath();\n\n        // do the magic\n        ModelGenerator.execute();\n\n        Generation.saveResults(\"" + testName + "/testOnClass\", \"expected\", resources.actual(\".*\\\\.java$\"));\n\n        // check the magic\n        assertFiles(resources.expected(\".*\\\\.java$\"), resources.actual(\".*\\\\.java$\"));\n    }\n\n    @Test\n    public void testOnField() throws Exception {\n        final Resources resources = Resources.name(\"" + testName + "/testOnField\");\n\n        Configuration.clean();\n        Configuration.modelSources = resources.input().getAbsolutePath();\n        Configuration.resourceSources = resources.input().getAbsolutePath();\n        Configuration.generatedSources = resources.actual().getAbsolutePath();\n        Configuration.modelPackage = \"io.superbiz.video.model\";\n        Configuration.modelSuffix = \"Model\";\n        Configuration.tempSource = resources.tempSource().getAbsolutePath();\n\n        // do the magic\n        ModelGenerator.execute();\n\n        Generation.saveResults(\"" + testName + "/testOnField\", \"expected\", resources.actual(\".*\\\\.java$\"));\n\n        // check the magic\n        assertFiles(resources.expected(\".*\\\\.java$\"), resources.actual(\".*\\\\.java$\"));\n    }\n}\n");
            tests.put("resources/" + testName + "/testOnField/input/io/superbiz/video/model/MovieModel.java", "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\npackage io.superbiz.video.model;\n\nimport org.tomitribe.api.Filter;\nimport org.tomitribe.api.Model;\nimport org.tomitribe.api.Resource;\n\n@Model\n@Resource\nclass MovieModel {\n    @Model(id = true, operation = Model.Operation.READ)\n    private String id;\n    @Model(operation = Model.Operation." + operation.name() + ")\n    private String title;\n    private String director;\n    private String genre;\n    @Model(operation = Model.Operation." + operation.name() + ")\n    private int year;\n    private int rating;\n}\n");
            tests.put("resources/" + testName + "/testOnClass/input/io/superbiz/video/model/MovieModel.java", "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\npackage io.superbiz.video.model;\n\nimport org.tomitribe.api.Filter;\nimport org.tomitribe.api.Model;\nimport org.tomitribe.api.Resource;\n\n@Model(operation = Model.Operation." + operation.name() + ")\n@Resource\nclass MovieModel {\n    @Model(id = true, operation = Model.Operation.READ)\n    private String id;\n    private String title;\n    private String director;\n    private String genre;\n    private int year;\n    private int rating;\n}\n");
            Generation.saveContent(tests, srcTest);
        }
    }
}

