/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.inget.test;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.tomitribe.inget.common.Utils;
import org.tomitribe.inget.test.CleanOnExit;
import org.tomitribe.inget.test.Generation;
import org.tomitribe.inget.test.Urls;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class Resources {
    private final File base;
    private final File actual;
    private final File tempSource;
    private final File expected;
    private final File input;
    private final List<Runnable> cleanup = new ArrayList<Runnable>();

    public Resources(String name) {
        URL resource = Resources.class.getClassLoader().getResource("root.txt");
        Assert.assertNotNull((Object)resource);
        File file = Urls.toFile(resource);
        Assert.assertNotNull((Object)file);
        this.base = new File(file.getParentFile(), name);
        this.expected = new File(this.base, "expected");
        this.input = new File(this.base, "input");
        this.actual = Files.tmpdir();
        this.tempSource = Files.tmpdir();
        this.cleanup.add(() -> this.saveResultsOnExit(name));
        this.cleanup.add(() -> CleanOnExit.delete(this.actual));
        this.cleanup.add(() -> CleanOnExit.delete(this.tempSource));
        Runtime.getRuntime().addShutdownHook(new Thread(this::cleanup));
    }

    private void cleanup() {
        this.cleanup.stream().forEach(Runnable::run);
    }

    private void saveResultsOnExit(String name) {
        if (!Boolean.getBoolean("saveResults")) {
            return;
        }
        try {
            Generation.saveResults(name, "expected", this.actual(".*"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Resources name(String name) {
        return new Resources(name);
    }

    private Map<String, File> map(File dir, String regex) throws IOException {
        LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        List files = Files.collect((File)dir, (String)regex);
        for (File file : files) {
            String relativePath = file.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
            map.put(relativePath, file);
        }
        return map;
    }

    public File expected() {
        return this.expected;
    }

    public File tempSource() {
        return this.tempSource;
    }

    public Map<String, File> expected(String regex) throws IOException {
        return this.map(this.expected(), regex);
    }

    public File actual() {
        return this.actual;
    }

    public Map<String, File> actual(String regex) throws IOException {
        return this.map(this.actual(), regex);
    }

    public File input() {
        return this.input;
    }

    public Resources input(String sourceCode) {
        CompilationUnit classUnit = JavaParser.parse((String)sourceCode);
        PackageDeclaration packageDeclaration = (PackageDeclaration)classUnit.getPackageDeclaration().orElseThrow(IllegalStateException::new);
        String path = packageDeclaration.getName().asString().replace(".", "/");
        ClassOrInterfaceDeclaration clazz = Utils.getClazz((CompilationUnit)classUnit);
        String className = clazz.getNameAsString();
        File file = new File(this.input, path + "/" + className + ".java");
        Files.mkparent((File)file);
        try {
            IO.copy((InputStream)IO.read((String)sourceCode), (File)file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public static Resources here() {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        String className = caller.getClassName().replaceAll(".*\\.", "");
        String methodName = caller.getMethodName();
        return new Resources(className + "/" + methodName);
    }
}

