/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.tomitribe.sabot.Config;
import org.tomitribe.sabot.ConfigurationResolver;
import org.tomitribe.util.editor.Converter;

@ApplicationScoped
public class ConfigurationProducer {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationProducer.class.getName());
    private final ConfigurationResolver resolver = ConfigurationResolver.get();

    @Produces
    @Config
    public Object resolveAndConvert(InjectionPoint injectionPoint) {
        String defaultValue;
        Config annotation = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
        String key = annotation.value();
        if (!this.resolver.isResolvableConfig(key, defaultValue = annotation.defaultValue())) {
            throw new IllegalStateException(String.format("Can't resolve config %s for environment `%s`.", key, this.resolver.getEnvironment()));
        }
        String value = this.resolver.resolve(key, defaultValue);
        Class toType = (Class)injectionPoint.getAnnotated().getBaseType();
        LOGGER.finest(String.format("Injecting %s for key %s in class %s", key, value, injectionPoint.toString()));
        return Converter.convert((Object)value, (Class)toType, (String)key);
    }
}

