/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.openejb.loader.SystemInstance;
import org.tomitribe.sabot.Environments;

public class ConfigurationResolver {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationResolver.class.getName());
    private static final ConfigurationResolver INSTANCE = new ConfigurationResolver();
    private final Properties properties = new Properties();
    private final String environment = SystemInstance.get().getOptions().get("environment", "test");

    ConfigurationResolver() {
        LOGGER.info(String.format("Environment: = %s", this.environment));
        this.properties.putAll((Map<?, ?>)Environments.getProperties(this.environment));
        Properties overrides = SystemInstance.get().getProperties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (!overrides.containsKey(entry.getKey())) continue;
            Object newValue = overrides.get(entry.getKey());
            LOGGER.info(String.format("Override config %s from `%s` to `%s`", entry.getKey(), entry.getValue(), newValue));
            entry.setValue(newValue);
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            LOGGER.info(String.format("Config: %s = `%s`", entry.getKey(), entry.getValue()));
        }
    }

    public boolean isResolvableConfig(String key, String defaultValue) {
        Objects.requireNonNull(key, "config key can not be null");
        Objects.requireNonNull(defaultValue, "default config value can not be null");
        return this.properties.containsKey(key) || !defaultValue.isEmpty();
    }

    public String resolve(String key, String defaultValue) {
        Objects.requireNonNull(key, "config key can not be null");
        Objects.requireNonNull(defaultValue, "default config value can not be null");
        return this.properties.getProperty(key, defaultValue);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static final ConfigurationResolver get() {
        return INSTANCE;
    }
}

