/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.tomitribe.sabot.Interpolation;

public enum Environments {

    private static final Logger LOGGER = Logger.getLogger(Environments.class.getName());

    public static Properties getProperties(String value) {
        Properties properties = new Properties();
        String base = "base";
        String resourceName = "base.properties";
        URL resource = Environments.getResource("base.properties");
        if (resource == null) {
            LOGGER.info("No base.properties found.");
        } else {
            properties.putAll((Map<?, ?>)Environments.load("base"));
        }
        for (String env : value.split(" *, *")) {
            properties.putAll((Map<?, ?>)Environments.load(env));
        }
        return Interpolation.interpolate(properties);
    }

    private static Properties load(String value) {
        Properties properties = new Properties();
        String resourceName = value + ".properties";
        URL resource = Environments.getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Can not find environment `" + resourceName + "` from the classpath.");
        }
        try (InputStream inputStream = resource.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not load environment `" + resource.toExternalForm() + "`.");
        }
        return properties;
    }

    private static URL getResource(String resourceName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource(resourceName);
        if (resource != null) {
            return resource;
        }
        return loader.getResource("/" + resourceName);
    }
}

