/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.tomitribe.sabot.Config;
import org.tomitribe.sabot.ConfigurationResolver;

public class ConfigurationExtension
implements Extension {
    private final Set<Type> types = new HashSet<Type>();
    private Bean<?> convBean;

    public void retrieveTypes(@Observes ProcessBean<?> pb) {
        ConfigurationResolver resolver = ConfigurationResolver.get();
        Set ips = pb.getBean().getInjectionPoints();
        for (InjectionPoint injectionPoint : ips) {
            if (!injectionPoint.getAnnotated().isAnnotationPresent(Config.class)) continue;
            Config annotation = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
            String key = annotation.value();
            if (!resolver.isResolvableConfig(key, annotation.defaultValue())) {
                throw new IllegalStateException(String.format("Unable to resolve config %s for environment '%s'. Make sure the following property is defined '%s = <your config value>' for the '%s' environment", key, resolver.getEnvironment(), key, resolver.getEnvironment()));
            }
            this.types.add(injectionPoint.getType());
        }
    }

    public void captureConvertBean(@Observes ProcessProducerMethod<?, ?> ppm) {
        if (ppm.getAnnotated().isAnnotationPresent(Config.class)) {
            this.convBean = ppm.getBean();
        }
    }

    public void addConverter(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        abd.addBean((Bean)new ConverterBean(this.convBean, this.types));
    }

    private static class ConverterBean
    implements Bean<Object> {
        private final Bean<Object> delegate;
        private final Set<Type> types;

        public ConverterBean(Bean convBean, Set<Type> types) {
            this.types = types;
            this.delegate = convBean;
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Class<?> getBeanClass() {
            return this.delegate.getBeanClass();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.delegate.getInjectionPoints();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Annotation> getQualifiers() {
            return this.delegate.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.delegate.getScope();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }

        public boolean isNullable() {
            return this.delegate.isNullable();
        }

        public Object create(CreationalContext<Object> creationalContext) {
            return this.delegate.create(creationalContext);
        }

        public void destroy(Object instance, CreationalContext<Object> creationalContext) {
            this.delegate.destroy(instance, creationalContext);
        }
    }
}

