/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.tomitribe.sabot.ConfigurationObserver;
import org.tomitribe.sabot.Environments;

public class ConfigurationResolver {
    public static final String ENVIRONMENT = "org.tomitribe.sabot.environment";
    private static final Logger LOGGER = Logger.getLogger(ConfigurationResolver.class.getName());
    private static final ConfigurationResolver instance = new ConfigurationResolver();
    private final Properties properties = new Properties();
    private final String environment = System.getProperty("org.tomitribe.sabot.environment");
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    private final List<ConfigurationObserver> observers = new ArrayList<ConfigurationObserver>();

    ConfigurationResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (!this.initialized.getAndSet(true)) {
            ArrayList<ConfigurationObserver> current;
            this.lock.lock();
            try {
                current = new ArrayList<ConfigurationObserver>(this.observers);
            }
            finally {
                this.lock.unlock();
            }
            String environment = this.environment;
            try {
                this.properties.putAll((Map<?, ?>)Environments.getProperties(environment));
            }
            catch (ResourceException e) {
                throw new RuntimeException("Failed to load environment: " + environment, e);
            }
            for (ConfigurationObserver configurationObserver : current) {
                configurationObserver.mergeConfiguration(this.properties);
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                LOGGER.info(String.format("Configuration: %s = `%s`", entry.getKey(), entry.getValue()));
            }
        }
    }

    public static void reset() {
        ConfigurationResolver.get().clear();
    }

    private void clear() {
        this.properties.clear();
        this.initialized.set(false);
    }

    public static void registerConfigurationObserver(ConfigurationObserver observer) {
        ConfigurationResolver.get().register(observer);
    }

    public static void deregisterConfigurationObserver(ConfigurationObserver observer) {
        ConfigurationResolver.get().deregister(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ConfigurationObserver observer) {
        this.lock.lock();
        try {
            if (!this.observers.contains(observer)) {
                this.observers.add(observer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister(ConfigurationObserver observer) {
        this.lock.lock();
        try {
            this.observers.remove(observer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isResolvableConfig(String key, String defaultValue) {
        this.initialize();
        Objects.requireNonNull(key, "config key can not be null");
        Objects.requireNonNull(defaultValue, "default config value can not be null");
        return this.properties.containsKey(key) || !defaultValue.isEmpty();
    }

    public String resolve(String key, String defaultValue) {
        this.initialize();
        Objects.requireNonNull(key, "config key can not be null");
        Objects.requireNonNull(defaultValue, "default config value can not be null");
        return this.properties.getProperty(key, defaultValue);
    }

    public String getEnvironment() {
        return null != this.environment ? this.environment : "base";
    }

    public static ConfigurationResolver get() {
        return instance;
    }
}

