/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.tomitribe.sabot.Interpolation;

public enum Environments {

    private static final Logger LOGGER = Logger.getLogger(Environments.class.getName());

    public static Properties getProperties(String environments) throws ResourceException {
        Properties properties = new Properties();
        Environments.loadBase(properties, "base");
        Environments.loadBase(properties, "test");
        if (null != environments) {
            for (String env : environments.split(" *, *")) {
                if ("test".equals(env) || "base".equals(env)) continue;
                properties.putAll((Map<?, ?>)Environments.load(env));
            }
        }
        return Interpolation.interpolate(properties);
    }

    private static void loadBase(Properties properties, String base) {
        String resourceName = base + ".properties";
        URL resource = Environments.getResource(resourceName);
        if (resource == null) {
            LOGGER.log(Level.FINE, "No " + resourceName + " found.");
        } else {
            try {
                properties.putAll((Map<?, ?>)Environments.load(base));
            }
            catch (ResourceException e) {
                LOGGER.log(Level.FINE, "The properties file '" + base + ".properties' was not found on the classpasth");
            }
        }
    }

    private static Properties load(String value) throws ResourceException {
        Properties properties = new Properties();
        String resourceName = value + ".properties";
        URL resource = Environments.getResource(resourceName);
        if (resource == null) {
            throw new ResourceException("Unable to find '" + resourceName + "' on the classpath");
        }
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new ResourceException("Failed to load environment '" + resource.toExternalForm() + "'");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return properties;
    }

    private static URL getResource(String resourceName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource(resourceName);
        if (resource != null) {
            return resource;
        }
        return loader.getResource("/" + resourceName);
    }
}

