/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.sabot;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Interpolation {

    private static final Pattern PATTERN = Pattern.compile("(\\$\\{)([\\w._-]+)(})");

    public static Properties interpolate(Properties properties) {
        return Interpolation._interpolate(Interpolation.copy(properties));
    }

    private static Properties copy(Properties properties) {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        return copy;
    }

    private static Properties _interpolate(Properties interpolated) {
        boolean interpolating = true;
        while (interpolating) {
            interpolating = false;
            for (Map.Entry<Object, Object> entry : interpolated.entrySet()) {
                String formatted;
                String value = entry.getValue().toString();
                if (value.equals(formatted = Interpolation.format(value, interpolated))) continue;
                interpolating = true;
                entry.setValue(formatted);
            }
        }
        return interpolated;
    }

    static String format(String input, Properties properties) {
        Matcher matcher = PATTERN.matcher(input);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            Object value = properties.get(key);
            if (value == null) continue;
            try {
                matcher.appendReplacement(buf, value.toString());
            }
            catch (Exception e) {}
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

