/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.listen;

import com.tomitribe.snitch.Filter;
import com.tomitribe.snitch.Method;
import com.tomitribe.snitch.asm.ClassVisitor;
import com.tomitribe.snitch.asm.MethodVisitor;
import com.tomitribe.snitch.asm.Opcodes;
import com.tomitribe.snitch.asm.Type;
import com.tomitribe.snitch.track.Enhance;
import com.tomitribe.snitch.util.AsmModifiers;
import java.util.ArrayList;
import java.util.Arrays;

public class InsertListenerVisitor
extends ClassVisitor
implements Opcodes {
    private final Filter<Type> filter;
    private String classInternalName;

    public InsertListenerVisitor(ClassVisitor classVisitor, Filter<Type> filter) {
        super(327680, classVisitor);
        this.filter = filter;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classInternalName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitEnd() {
        this.filter.end();
        super.visitEnd();
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        Method method = Method.fromDescriptor(name, desc, this.classInternalName);
        final Type listener = this.filter.accept(method);
        if (listener == null) {
            return methodVisitor;
        }
        return new MethodVisitor(327680, methodVisitor){

            @Override
            public void visitCode() {
                boolean isStatic = AsmModifiers.isStatic(access);
                Type[] argumentTypes = this.getArgumentTypes();
                ArrayList<Type> variables = new ArrayList<Type>(Arrays.asList(argumentTypes));
                if (isStatic) {
                    variables.remove(0);
                    this.visitInsn(1);
                }
                Enhance.load(variables, this);
                String methodDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, argumentTypes);
                this.visitMethodInsn(184, listener.getInternalName(), name, methodDescriptor);
                super.visitCode();
            }

            private Type[] getArgumentTypes() {
                Type[] original = Type.getArgumentTypes(desc);
                Type[] expanded = new Type[original.length + 1];
                expanded[0] = Type.getObjectType(InsertListenerVisitor.this.classInternalName);
                System.arraycopy(original, 0, expanded, 1, original.length);
                return expanded;
            }
        };
    }
}

