/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.track;

import com.tomitribe.snitch.Method;
import com.tomitribe.snitch.track.Bytecode;
import com.tomitribe.snitch.track.Clazz;
import com.tomitribe.snitch.track.Log;
import com.tomitribe.snitch.track.TimingEnhancer;
import com.tomitribe.snitch.track.TrackEnhancer;
import com.tomitribe.snitch.util.IO;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Enhancer {
    private final Map<String, Clazz> classes = new HashMap<String, Clazz>();

    public static Enhancer create(File file) throws IOException {
        Properties properties = IO.readProperties(file);
        return Enhancer.create(properties);
    }

    public Clazz getClazz(String name) {
        name = this.normalize(name);
        return this.classes.get(name);
    }

    public static Enhancer create(Properties properties) {
        Enhancer configuration = new Enhancer();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Method method = Method.fromToString(value);
            if (key.startsWith("@")) {
                configuration.clazz(method.getClassName()).track(method, key.substring(1));
                continue;
            }
            configuration.clazz(method.getClassName()).time(method, key);
        }
        return configuration;
    }

    private Clazz clazz(String name) {
        Clazz clazz = this.classes.get(name = this.normalize(name));
        if (clazz != null) {
            return clazz;
        }
        clazz = new Clazz(name);
        this.classes.put(clazz.getInternalName(), clazz);
        return clazz;
    }

    private String normalize(String name) {
        if (name.contains(".")) {
            name = name.replace('.', '/');
        }
        return name;
    }

    public byte[] enhance(String className, byte[] bytecode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        if (className == null) {
            return bytecode;
        }
        Clazz clazz = this.getClazz(className);
        if (clazz == null) {
            return bytecode;
        }
        Log.log("Tracking %s", className);
        if (clazz.shouldTrack()) {
            bytecode = Bytecode.modify(bytecode, TrackEnhancer.class, clazz);
        }
        if (clazz.shouldTime()) {
            bytecode = Bytecode.modify(bytecode, TimingEnhancer.class, clazz);
        }
        return bytecode;
    }
}

