/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.track;

import com.tomitribe.snitch.Filter;
import com.tomitribe.snitch.Method;
import com.tomitribe.snitch.asm.AnnotationVisitor;
import com.tomitribe.snitch.asm.ClassVisitor;
import com.tomitribe.snitch.asm.MethodVisitor;
import com.tomitribe.snitch.asm.Opcodes;
import com.tomitribe.snitch.track.Enhance;
import com.tomitribe.snitch.track.Log;
import com.tomitribe.snitch.track.Monitor;
import java.util.Map;

public class GenericEnhancer
extends ClassVisitor
implements Opcodes {
    private final Filter<String> filter;
    private String classInternalName;
    private int version;
    private final boolean track;

    public GenericEnhancer(ClassVisitor classVisitor, Filter<String> filter) {
        this(classVisitor, filter, false);
    }

    public GenericEnhancer(ClassVisitor classVisitor, Filter<String> filter, boolean track) {
        super(327680, classVisitor);
        this.filter = filter;
        this.track = track;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classInternalName = name;
        this.version = version;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitEnd() {
        this.filter.end();
        super.visitEnd();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        try {
            Method method = Method.fromDescriptor(name, desc, this.classInternalName);
            String monitor = this.filter.accept(method);
            if (monitor != null) {
                MethodVisitor newMethod = Enhance.visit(this.cv, monitor, this.classInternalName, this.version, access, name, desc, signature, exceptions, this.track);
                MethodVisitor movedMethod = super.visitMethod(access, Enhance.target(name), desc, signature, exceptions);
                return new MoveAnnotationsVisitor(movedMethod, newMethod);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        catch (RuntimeException e) {
            Log.err("Enhance failed %s %s %s", this.classInternalName, name, desc);
            throw e;
        }
    }

    public static class MethodFilter
    implements Filter<String> {
        private final Map<Method, Monitor> methods;

        public MethodFilter(Map<Method, Monitor> methods) {
            this.methods = methods;
        }

        @Override
        public String accept(Method method) {
            Monitor monitor = this.methods.remove(method);
            if (monitor != null) {
                return monitor.getName();
            }
            return null;
        }

        @Override
        public void end() {
            for (Map.Entry<Method, Monitor> unused : this.methods.entrySet()) {
                Log.err("No Such Method: %s = %s", unused.getValue().getName(), unused.getKey());
            }
        }
    }

    public static class MoveAnnotationsVisitor
    extends MethodVisitor {
        private final MethodVisitor newMethod;

        public MoveAnnotationsVisitor(MethodVisitor movedMethod, MethodVisitor newMethod) {
            super(327680, movedMethod);
            this.newMethod = newMethod;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.newMethod.visitAnnotation(desc, visible);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return this.newMethod.visitParameterAnnotation(parameter, desc, visible);
        }

        @Override
        public void visitEnd() {
            this.newMethod.visitEnd();
            super.visitEnd();
        }
    }
}

