/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch;

import com.tomitribe.snitch.asm.Type;
import com.tomitribe.snitch.util.Join;
import java.util.Arrays;

public class Method {
    private final String className;
    private final String methodName;
    private final Type[] arguments;

    public Method(java.lang.reflect.Method method) {
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        this.arguments = Type.getArgumentTypes(method);
    }

    public Method(String className, String methodName, Type[] arguments) {
        this.className = className;
        this.methodName = methodName;
        this.arguments = arguments;
    }

    public static Method fromDescriptor(String name, String desc, String className) {
        return new Method(className, name, Type.getArgumentTypes(desc));
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Type[] getArguments() {
        return this.arguments;
    }

    public static Method fromToString(String toStringValue) {
        String rawName = null;
        String rawArgs = null;
        String[] split = toStringValue.split("[()]");
        if (split.length < 1) {
            throw new IllegalArgumentException("Invalid toString format: " + toStringValue);
        }
        if (toStringValue.contains("()") || toStringValue.length() == 1) {
            rawName = split[0];
            rawArgs = "";
        } else {
            rawName = split[0];
            rawArgs = split[1];
        }
        rawName = rawName.trim();
        rawName = rawName.replaceAll(".* ", "");
        rawArgs = rawArgs.replaceAll("\\s", "");
        String className = rawName.substring(0, rawName.lastIndexOf(46));
        String methodName = rawName.substring(rawName.lastIndexOf(46) + 1, rawName.length());
        String[] args = rawArgs.length() == 0 ? new String[]{} : rawArgs.split(",");
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            String[] array = args[i].split("\\[");
            String type = Method.type(array[0]);
            for (int j = 1; j < array.length; ++j) {
                type = "[" + type;
            }
            types[i] = Type.getType(type);
        }
        return new Method(className, methodName, types);
    }

    private static String type(String raw) {
        if ("byte".equals(raw)) {
            return "B";
        }
        if ("boolean".equals(raw)) {
            return "Z";
        }
        if ("char".equals(raw)) {
            return "C";
        }
        if ("short".equals(raw)) {
            return "S";
        }
        if ("int".equals(raw)) {
            return "I";
        }
        if ("long".equals(raw)) {
            return "J";
        }
        if ("float".equals(raw)) {
            return "F";
        }
        if ("double".equals(raw)) {
            return "D";
        }
        return "L" + raw.replace('.', '/') + ";";
    }

    public static String type(Type type) {
        if (Type.BYTE_TYPE.equals(type)) {
            return "byte";
        }
        if (Type.BOOLEAN_TYPE.equals(type)) {
            return "boolean";
        }
        if (Type.CHAR_TYPE.equals(type)) {
            return "char";
        }
        if (Type.SHORT_TYPE.equals(type)) {
            return "short";
        }
        if (Type.INT_TYPE.equals(type)) {
            return "int";
        }
        if (Type.LONG_TYPE.equals(type)) {
            return "long";
        }
        if (Type.FLOAT_TYPE.equals(type)) {
            return "float";
        }
        if (Type.DOUBLE_TYPE.equals(type)) {
            return "double";
        }
        return type.getClassName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className).append(".");
        sb.append(this.methodName).append("(");
        sb.append(Join.join(",", new Join.NameCallback<Type>(){

            @Override
            public String getName(Type type) {
                return Method.type(type);
            }
        }, this.arguments));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        if (!Arrays.equals(this.arguments, method.arguments)) {
            return false;
        }
        return this.methodName.equals(method.methodName);
    }

    public int hashCode() {
        int result = this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }
}

