/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Join {
    public static final MethodCallback METHOD_CALLBACK = new MethodCallback();
    public static final ClassCallback CLASS_CALLBACK = new ClassCallback();

    private Join() {
    }

    public static String join(String delimiter, Collection collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            sb.append(obj).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static String join(String delimiter, Object ... collection) {
        if (collection.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : collection) {
            sb.append(obj).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static <T> String join(String delimiter, NameCallback<T> nameCallback, T ... collection) {
        if (collection.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T obj : collection) {
            sb.append(nameCallback.getName(obj)).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static <T> String join(String delimiter, NameCallback<T> nameCallback, Collection<T> collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T obj : collection) {
            sb.append(nameCallback.getName(obj)).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static <T> List<String> strings(Collection<T> collection, NameCallback<T> callback) {
        ArrayList<String> list = new ArrayList<String>();
        for (T t : collection) {
            String name = callback.getName(t);
            list.add(name);
        }
        return list;
    }

    public static class ClassCallback
    implements NameCallback<Class<?>> {
        @Override
        public String getName(Class<?> cls) {
            return cls.getName();
        }
    }

    public static class MethodCallback
    implements NameCallback<Method> {
        @Override
        public String getName(Method method) {
            return method.getName();
        }
    }

    public static class FileCallback
    implements NameCallback<File> {
        @Override
        public String getName(File file) {
            return file.getName();
        }
    }

    public static interface NameCallback<T> {
        public String getName(T var1);
    }
}

