/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.agent;

import com.tomitribe.snitch.track.Enhancer;
import com.tomitribe.snitch.track.Log;
import com.tomitribe.snitch.util.IO;
import com.tomitribe.snitch.util.Join;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Properties;

public class Agent {
    private static Instrumentation instrumentation;

    private Agent() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        if (Agent.instrumentation != null) {
            return;
        }
        Agent.initialize(agentArgs, instrumentation);
        Agent.instrumentation = instrumentation;
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if (Agent.instrumentation != null) {
            return;
        }
        Agent.initialize(agentArgs, instrumentation);
        Agent.instrumentation = instrumentation;
    }

    private static void initialize(String agentArgs, Instrumentation instrumentation) {
        try {
            if (agentArgs == null) {
                Agent.err("Tracker not installed.  No properties file specified", new Object[0]);
                return;
            }
            String[] split = agentArgs.trim().split(" *, *");
            if (agentArgs.length() == 0) {
                Agent.err("Tracker not installed.  No properties file specified", new Object[0]);
                return;
            }
            ArrayList<File> files = new ArrayList<File>();
            for (String path : split) {
                File file = new File(path);
                if (!file.exists()) {
                    Agent.err("Configuration file does not exist '%s'", file.getAbsolutePath());
                    continue;
                }
                if (!file.isFile()) {
                    Agent.err("Path is not a file '%s'", file.getAbsolutePath());
                    continue;
                }
                if (!file.canRead()) {
                    Agent.err("Cannot read properties file '%s'", file.getAbsolutePath());
                    continue;
                }
                files.add(file);
            }
            if (files.size() == 0) {
                Agent.err("Tracker not installed.  No usable configuration files.", new Object[0]);
                return;
            }
            Properties properties = new Properties();
            for (File file : files) {
                IO.readProperties(file, properties);
            }
            instrumentation.addTransformer(new Tracker(Enhancer.create(properties), instrumentation));
            Agent.out("Tracker installed.  Configuration files '%s'", Join.join(",", new Join.NameCallback<File>(){

                @Override
                public String getName(File object) {
                    return object.getAbsolutePath();
                }
            }, files));
        }
        catch (Throwable e) {
            Agent.err("Failed %s", e.getMessage());
            e.printStackTrace();
        }
    }

    private static void out(String format, Object ... details) {
        Log.log("Agent:: %s%n", String.format(format, details));
    }

    private static void err(String format, Object ... details) {
        Log.err("Agent:: %s%n", String.format(format, details));
    }

    public static class Tracker
    implements ClassFileTransformer {
        private final Enhancer enhancer;

        public Tracker(Enhancer enhancer) {
            this.enhancer = enhancer;
        }

        public Tracker(Enhancer enhancer, Instrumentation instrumentation) {
            this.enhancer = enhancer;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            try {
                return this.enhancer.enhance(className, classfileBuffer);
            }
            catch (Throwable e) {
                Agent.err("Enhance Failed for '%s' : %s %s", new Object[]{className, e.getClass().getName(), e.getMessage()});
                e.printStackTrace();
                return classfileBuffer;
            }
        }
    }
}

