/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.annotate;

import com.tomitribe.snitch.asm.AnnotationVisitor;
import com.tomitribe.snitch.asm.ClassVisitor;
import com.tomitribe.snitch.asm.ClassWriter;
import com.tomitribe.snitch.asm.Opcodes;
import com.tomitribe.snitch.asm.Type;
import com.tomitribe.snitch.track.Bytecode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class AnnotateType
implements Function<byte[], byte[]> {
    private final String annotationClassName;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final boolean visible;

    public AnnotateType(String annotationClassName, Map<String, Object> attributes, boolean visible) {
        this.annotationClassName = annotationClassName;
        this.attributes.putAll(attributes);
        this.visible = visible;
    }

    @Override
    public byte[] apply(byte[] bytes) {
        ClassWriter cw = new ClassWriter(1);
        AnnotateTypeVisitor classAdapter = new AnnotateTypeVisitor(cw);
        Bytecode.read(bytes, classAdapter);
        return cw.toByteArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    class AnnotateTypeVisitor
    extends ClassVisitor
    implements Opcodes {
        public AnnotateTypeVisitor(ClassWriter classVisitor) {
            super(589824, classVisitor);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            String s = AnnotateType.this.annotationClassName.replace('.', '/');
            String typeDescriptor = "L" + s + ";";
            AnnotationVisitor annotationVisitor = this.visitAnnotation(typeDescriptor, AnnotateType.this.visible);
            for (Map.Entry entry : AnnotateType.this.attributes.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Class) {
                    Class aClass = (Class)value;
                    value = Type.getType(aClass);
                }
                annotationVisitor.visit((String)entry.getKey(), value);
            }
            annotationVisitor.visitEnd();
        }
    }

    public static class Builder {
        private String annotationClassName;
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
        private boolean visible;

        public Builder annotation(String className) {
            this.annotationClassName = className;
            return this;
        }

        public Builder annotation(Class<?> clazz) {
            this.annotationClassName = clazz.getName();
            return this;
        }

        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Builder set(String name, String value) {
            return this.put(name, value);
        }

        public Builder set(String name, Class<?> value) {
            return this.put(name, value);
        }

        public Builder set(String name, Boolean value) {
            return this.put(name, value);
        }

        public Builder set(String name, Byte value) {
            return this.put(name, value);
        }

        public Builder set(String name, Character value) {
            return this.put(name, value);
        }

        public Builder set(String name, Short value) {
            return this.put(name, value);
        }

        public Builder set(String name, Integer value) {
            return this.put(name, value);
        }

        public Builder set(String name, Long value) {
            return this.put(name, value);
        }

        public Builder set(String name, Float value) {
            return this.put(name, value);
        }

        public Builder set(String name, Double value) {
            return this.put(name, value);
        }

        private Builder put(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        public AnnotateType build() {
            return new AnnotateType(this.annotationClassName, this.attributes, this.visible);
        }
    }
}

