/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.listen;

import com.tomitribe.snitch.Filter;
import com.tomitribe.snitch.Method;
import com.tomitribe.snitch.asm.ClassWriter;
import com.tomitribe.snitch.asm.Type;
import com.tomitribe.snitch.listen.Clazz;
import com.tomitribe.snitch.listen.InsertListenerVisitor;
import com.tomitribe.snitch.track.Bytecode;
import com.tomitribe.snitch.track.Log;
import com.tomitribe.snitch.util.IO;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Enhancer {
    private final Map<String, Clazz> classes = new HashMap<String, Clazz>();

    public static Enhancer create(File file) throws IOException {
        Properties properties = IO.readProperties(file);
        return Enhancer.create(properties);
    }

    public Clazz getClazz(String name) {
        name = Enhancer.normalize(name);
        return this.classes.get(name);
    }

    public static Enhancer create(Properties properties) {
        Enhancer configuration = new Enhancer();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Method method = Method.fromToString(key);
            Type type = Type.getObjectType(Enhancer.normalize(value));
            configuration.clazz(method.getClassName()).setListener(method, type);
        }
        return configuration;
    }

    private Clazz clazz(String name) {
        Clazz clazz = this.classes.get(name = Enhancer.normalize(name));
        if (clazz != null) {
            return clazz;
        }
        clazz = new Clazz(name);
        this.classes.put(clazz.getInternalName(), clazz);
        return clazz;
    }

    private static String normalize(String name) {
        if (name.contains(".")) {
            name = name.replace('.', '/');
        }
        return name;
    }

    public byte[] enhance(String className, byte[] bytecode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        Clazz clazz = this.getClazz(className);
        if (clazz == null) {
            return bytecode;
        }
        if (!clazz.shouldListen()) {
            return bytecode;
        }
        Log.log("Listen %s", className);
        ClassWriter cw = new ClassWriter(1);
        MethodFilter methodFilter = new MethodFilter(clazz.getListeners());
        InsertListenerVisitor classAdapter = new InsertListenerVisitor(cw, methodFilter);
        Bytecode.read(bytecode, classAdapter);
        return cw.toByteArray();
    }

    public static class MethodFilter
    implements Filter<Type> {
        private final Map<Method, Type> methods;

        public MethodFilter(Map<Method, Type> methods) {
            this.methods = methods;
        }

        @Override
        public Type accept(Method method) {
            return this.methods.remove(method);
        }

        @Override
        public void end() {
            for (Map.Entry<Method, Type> unused : this.methods.entrySet()) {
                Log.err("No Such Method: %s for listener %s", unused.getKey(), unused.getValue().getInternalName());
            }
        }
    }
}

