/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.listen;

import com.tomitribe.snitch.Method;
import com.tomitribe.snitch.asm.ClassWriter;
import com.tomitribe.snitch.listen.InsertStaticCallVisitor;
import com.tomitribe.snitch.track.Bytecode;
import com.tomitribe.snitch.util.Join;
import java.util.Objects;
import java.util.function.Function;

public class StaticNoArgCallback
implements Function<byte[], byte[]> {
    private final Method find;
    private final Method insert;

    private StaticNoArgCallback(Method find, Method insert) {
        Objects.requireNonNull(find);
        Objects.requireNonNull(insert);
        if (insert.getArguments().length != 0) {
            throw new IllegalArgumentException("Insert method must have no arguments.  Found: " + Join.join(", ", insert.getArguments()));
        }
        this.find = find;
        this.insert = insert;
    }

    @Override
    public byte[] apply(byte[] bytes) {
        ClassWriter cw = new ClassWriter(1);
        InsertStaticCallVisitor classAdapter = new InsertStaticCallVisitor(cw, this.find, this.insert);
        Bytecode.read(bytes, classAdapter);
        return cw.toByteArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Method find;
        Method insert;

        public Builder find(Method method) {
            this.find = method;
            return this;
        }

        public Builder find(String methodToString) {
            this.find = Method.fromToString(methodToString);
            return this;
        }

        public Builder find(java.lang.reflect.Method method) {
            this.find = new Method(method);
            return this;
        }

        public Builder insert(Class<?> clazz, String method) {
            this.insert = Method.fromDescriptor(method, "()V", clazz.getName());
            return this;
        }

        public Builder insert(String methodToString) {
            this.insert = Method.fromToString(methodToString);
            return this;
        }

        public Builder insert(java.lang.reflect.Method method) {
            this.insert = new Method(method);
            return this;
        }

        public Function<byte[], byte[]> build() {
            return new StaticNoArgCallback(this.find, this.insert);
        }
    }
}

