/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.track;

import com.tomitribe.snitch.asm.ClassReader;
import com.tomitribe.snitch.asm.ClassVisitor;
import com.tomitribe.snitch.asm.ClassWriter;
import com.tomitribe.snitch.track.Clazz;
import com.tomitribe.snitch.util.IO;
import com.tomitribe.snitch.util.Unsafe;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;

public class Bytecode {
    private Bytecode() {
    }

    public static Class modify(URLClassLoader classLoader, Class<? extends ClassVisitor> adapterClass, Clazz clazz) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        byte[] originalBytes = Bytecode.readClassFile((ClassLoader)classLoader, clazz.getName());
        byte[] modifiedBytes = Bytecode.modify(originalBytes, adapterClass, clazz);
        return Bytecode.defineClass(modifiedBytes, clazz.getName(), classLoader);
    }

    public static byte[] readClassFile(Class clazz) throws IOException {
        return Bytecode.readClassFile(clazz.getClassLoader(), clazz);
    }

    public static byte[] readClassFile(ClassLoader classLoader, Class clazz) throws IOException {
        String internalName = clazz.getName().replace('.', '/') + ".class";
        URL resource = classLoader.getResource(internalName);
        return IO.readBytes(resource);
    }

    public static byte[] readClassFile(ClassLoader classLoader, String className) throws IOException {
        String internalName = className.replace('.', '/') + ".class";
        URL resource = classLoader.getResource(internalName);
        return IO.readBytes(resource);
    }

    public static Class defineClass(byte[] bytes, String className, ClassLoader classLoader) {
        return Unsafe.defineClass(className, bytes, 0, bytes.length, classLoader, null);
    }

    public static byte[] modify(byte[] bytes, Clazz clazz, Class<? extends ClassVisitor> ... adapterClasses) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        for (Class<? extends ClassVisitor> adapterClass : adapterClasses) {
            bytes = Bytecode.modify(bytes, adapterClass, clazz);
        }
        return bytes;
    }

    public static byte[] modify(byte[] originalBytes, Class<? extends ClassVisitor> adapterClass, Clazz clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ClassWriter cw = new ClassWriter(1);
        Constructor<? extends ClassVisitor> constructor = adapterClass.getConstructor(ClassVisitor.class, Clazz.class);
        ClassVisitor classAdapter = constructor.newInstance(cw, clazz);
        Bytecode.read(originalBytes, classAdapter);
        return cw.toByteArray();
    }

    public static void read(byte[] originalBytes, ClassVisitor classAdapter) {
        ClassReader cr = new ClassReader(originalBytes);
        cr.accept(classAdapter, 8);
    }

    public static void modifyAndDefine(ClassLoader loader, Clazz clazz, Class<? extends ClassVisitor> ... classes) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        byte[] bytes = Bytecode.readClassFile(loader, clazz.getName());
        bytes = Bytecode.modify(bytes, clazz, classes);
        Bytecode.defineClass(bytes, clazz.getName(), loader);
    }
}

